<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-bigprice/lego:layout">
    <table cellspacing="0">
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:layout"/>
    </table>
</xsl:template>

<xsl:template match="lego:b-bigprice/lego:layout | lego:b-bigprice/lego:layout/lego:row" mode="lego:layout">
    <tr>
        <xsl:apply-templates select="lego:gap | lego:column" mode="lego:layout"/>
    </tr>
</xsl:template>

<xsl:template match="lego:b-bigprice/lego:layout[lego:row]" mode="lego:layout">
    <xsl:apply-templates select="lego:row" mode="lego:layout"/>
</xsl:template>

<xsl:template match="lego:gap" mode="lego:layout">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <i class="{lego:name(.)}__i"></i>
    </td>
</xsl:template>

<xsl:template match="lego:column" mode="lego:layout">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<xsl:template match="lego:gap | lego:column" mode="lego:block-attributes">
    <xsl:copy-of select="@colspan | @rowspan"/>
    <xsl:apply-imports/>
</xsl:template>

</xsl:stylesheet>
