(function($, Lego) {

Lego.block['b-bugreport-link'] = function(params) {

    var SendMail = {
        sendForm: function(form, url, onsuccess, onerror) {
            var that = this;
            $(form).ajaxSubmit({
                url: url,
                iframe: true,
                type: 'POST',
                success: function(data) {
                    if ($.isFunction(onsuccess)) { onsuccess(data); }
                },
                error: function() {
                    if ($.isFunction(onerror)) { onerror(); }
                }
            });
        }
    };

    var $this = $(this);

    var $bPopup = $('.b-popup'),
        $form = $bPopup.find('form');

    $bPopup.delegate('.js-action-send, .js-send-feedback', 'click', sending);

    $bPopup.delegate('.b-popup__close, .js-action-cancel', 'click', close);

    $this
        .find('.b-pseudo-link')
        .click(function() {

        $bPopup.removeClass('i-hidden');
        $('.b-paranja').removeClass('i-hidden');

        $bPopup.find('input[name=email]').val('rasp@yandex.ru');
        $bPopup.find('input[name=req]').val($.cookie('yandexuid'));
        $bPopup.find('input[name=att]').val('');

        var info = '\n\n----\n\n' +
                   'Имя пользователя: ' + Lego.params.login + '\n\n' +
                   'Страница: ' + window.location.href.toString() + '\n\n' +
                   'Размер экрана: ' + screen.width + "x" + screen.height + "x" + (screen.colorDepth ? screen.colorDepth : screen.pixelDepth) + '\n\n' +
                   'Размер браузера: ' + $(window).width() + "x" + $(window).height() + '\n\n' +
                   'User-agent: ' + navigator.userAgent;

        var pluginsHash = {}; // В этом хеше будем запоминать уже выведенные плагины, чтобы не было дублирования
        var pluginsStr = '';

        $.each(navigator.plugins, function(k, v) {
            var plugin = v.name;
            if (v.version) {
                plugin += ', ' + v.version;
            } else {
                if (v.name === 'Shockwave Flash') {
                    plugin = v.description;
                }
            }

            if (!pluginsHash[plugin]) {
                pluginsStr += '\n* ' + plugin;
                pluginsHash[plugin] = true;
            }
        });

        if (pluginsStr) {
            info += '\n\nPlugins:' + pluginsStr;
        }

        $bPopup.find('textarea').val(info);

        setPopupPosition();

        $(window).bind('resize scroll', setPopupPosition);
    });

    function close() {
        $('.b-paranja').addClass('i-hidden');
        $bPopup.addClass('i-hidden');

        $bPopup.find('.b-popup__confirm').removeClass('i-hidden');
        $bPopup.find('.js-sending').html('').addClass('i-hidden');
        $form.removeClass('i-hidden');

        $(window).unbind('resize scroll', setPopupPosition);
    }


    function setBody(html) {
        $form.addClass('i-hidden');

        $bPopup
            .find('.js-sending')
            .html(html)
            .removeClass('i-hidden');

        $bPopup.find('.b-popup__confirm').addClass('i-hidden');
    }

    function sending() {
        setBody('<p>Подождите немного.</p>');

        SendMail.sendForm($form, '/async/bugreport', success, error);
    }

    function error() {
        setBody('<p>Сообщение не отправилось.</p><p><span class="b-pseudo-link js-send-feedback">Попробовать еще раз</span></p>');
    }

    function success(response) {
            if ($(response).text() != 1) {
                    error();
                    return;
            }
        setBody('<p>Сообщение отправлено.</p>');
        window.setTimeout(function() {
            close();
        }, 2000);
    }

    function setPopupPosition() {
        var $popup = $bPopup.filter('.b-popup'),
            $table = $popup.find('.b-popup__box');

        $popup.css({
            top: ($(window).height() - $table.height() - 10) / 2 + $(window).scrollTop(),
            left: ($(window).width() - $table.width()) / 2
        });
    }

}

})(jQuery, window.Lego);
