(function() {

function qnounform(n) {
    var dd = n % 100,
        d = n % 10;

    if(dd >= 11 && dd <= 14)
        return 0;
    else if(d == 1)
        return 1;
    else if (d >= 2 && d <= 4)
        return 2;
    else
        return 0;
}

BEM.DOM.decl({ name : 'b-form', modName : 'type', modVal : 'order' }, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            var _this = this,
                sex = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'sex' });

            this.pricetable = this.findBlockInside('b-pricetable');
            this.summ = this.findBlockInside('b-pricetable-summ');

            this.adults = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'adults' });
            this.children = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'children' });
            this.infants = this.findBlockInside({ blockName : 'b-dropdowna', modName : 'type', modVal : 'infants' });

            this.summ = this.findBlockInside('b-pricetable-summ');

            this.inputs = {
                'adults': this.domElem.find('input[name=n_adult]'),
                'children': this.domElem.find('input[name=n_child]'),
                'infants': this.domElem.find('input[name=n_infant]'),
                'car_gender': this.domElem.find('input[name=car_gender]')
            };

            if(!this.inputs.adults.val())
                this.inputs.adults.val(1);

            this._handleSeatsDropdown('adults');
            this._handleSeatsDropdown('children');
            this._handleSeatsDropdown('infants');

            this.inputs.car_gender.val('');

            if(sex) {
                this.inputs.car_gender.val('mixed');

                $.each(this.findBlocksInside(sex.elem('popup'), 'b-link'), function() {

                    this.on('click', function(e) {

                        var s = this.params.value;

                        sex.getPopup().hide();
                        sex.findBlockInside('switcher', 'b-link').domElem.html(e.block.domElem.html());

                        _this.inputs.car_gender.val(s);

                        _this.findBlockInside('b-pricetable').getOpenSchema().trigger('sexChange', s);
                    });

                });
            }

            this.bindTo('submit', this._onSubmit);

        }

    },

    _handleSeatsDropdown : function(cat) {
        var _this = this,
            dropdown = this[cat];

        if(!dropdown)
            return;

        $.each(this.findBlocksInside(dropdown.elem('popup'), 'b-link'), function() {

            this.on('click', function(e) {

                var n = this.params.value,
                    schema = _this.pricetable.getOpenSchema();

                dropdown.getPopup().hide();

                dropdown.findBlockInside('switcher', 'b-link').domElem.html(e.block.domElem.html());

                _this.inputs[cat].val(n);

                if(!_this.checkQuantities())
                    return;

                if(schema)
                    schema.trigger('seatsChange');
                else
                    _this.setTotal(_this.getData());
            });

        });

    },

    setTotal: function(data, extra) {
        var numbers;

        data = $.extend({}, data, extra);

        if(data.selected) {
            var seats = data.selected.map(function (seat) {
                var json = {
                    number: seat.number
                };

                if (seat.level !== undefined) {
                    json.level = seat.level;
                }

                return json;
            });

            this.domElem.find('input[name=seats]').val(JSON.stringify(seats));

            numbers = data.selected.map(function (seat) { return seat.number; });
        }


        var description_key = data.description_key ? data.description_key : 'order-description-dynamic';
        var q = this.getQuantities();

        var description = BEM.I18N('b-form', description_key, {
            'seats-number': q.adults + q.children,
            'coupes-number': data.coupes ? data.coupes : '',
            'seats': numbers ? numbers.join(', ') : '',
            'coach-number': data.coach,
            'coach-is-two': data.coach == 2
        });

        if (!data.total) {
            data.total = q.adults * data.tariff + q.children * data.childTariff;
        }

        this.domElem.find('input[name=total]').val(data.total);

        this.summ.showTotal(description, data.total, data.currency, data.from);
    },

    getData: function() {

        var choice = this.pricetable.getChoice();

        return {
            tariff: parseFloat(choice.tariff),
            from: choice.from,
            childTariff: parseFloat(choice.childtariff) || 0,
            currency: choice.currency || BEM.blocks['i-global'].param('currency').base,
            coach: parseInt(choice.coach, 10)
        };

    },

    getQuantities: function() {

        var q = {};

        $.each(this.inputs, function(cat, input) {
            q[cat] = parseInt(input.val()) || 0;
        });

        return q;

    },

    checkQuantities: function() {

        if(this.params['partner-code'] == 'ufs') {

            var q = this.getQuantities();

            if((q.adults + q.children + q.infants > 4) || (q.adults < 1) || (q.infants > q.adults)) {

                this.summ.showError(this.params['правила заказа']);

                return false;

            }

        }

        this.summ.clear();

        return true;

    },

    _onSubmit : function(e) {
//        e.preventDefault();
//        yaCounter99704.hit($.parseQuery($('.b-pricetable__radio:checked').val()).partner + '_click');
//        addCounter(168, 2190);
//        var form = this.domElem;
//        setTimeout(function() {form.submit()}, 1000);

    }

});

})();
