BEM.DOM.decl({ name: 'b-map', modName: 'type', modVal: 'route' }, {

    onSetMod: {
        'js': function(){
            var self = this,
                data = self.params,
                map,
                mediaUrl = BEM.blocks['i-global'].param('static-host'),
                bounds = [data.first, data.last];

            $.each(data.stations, function(j, station) {
                if(station[0] === null) {
                    return true;
                }
                var point = station[0];
                if(bounds[0][0] > point[0]) bounds[0][0] = point[0];
                if(bounds[0][1] > point[1]) bounds[0][1] = point[1];
                if(bounds[1][0] < point[0]) bounds[1][0] = point[0];
                if(bounds[1][1] < point[1]) bounds[1][1] = point[1];
            });

            ymaps.ready(function() {
                var
                    map = new ymaps.Map("b-map", {
                        center: [37.64, 55.76],
                        zoom: 10,
                        behaviors: ["default", "scrollZoom"]
                    });

                map.setBounds(bounds, {precizeZoom: false});

                map.controls
                    .add("zoomControl")
                    .add(new ymaps.control.TypeSelector())
                    .add("mapTools");

                // Построение маршрута
                $.each(data.segments, function(i, segment) {
                    if(segment === null) {
                        // Пропускаем пустые сегменты
                        return;
                    }

                    var polyline = new ymaps.Polyline(segment[0], {
                    }, {
                        strokeColor: '#dd0000dd',
                        strokeWidth: 3
                    });

                    map.geoObjects.add(polyline);
                });

                $.each(data.stations, function(i, station) {
                    if(station[0] === null) {
                        // если не указаны координаты, то пропускаем
                        return;
                    }

                    var point = station[0],
                        arrival = station[2],
                        departure = station[3],
                        id = station[4],
                        link = id ? ('<a href="/station/' + id + '/">' + BEM.I18N('b-map', 'station-panel') +'</a><br />') : '',
                        times,
                        name = station[1],
                        options = {
                            iconImageSize: [9, 9],
                            iconImageOffset: [-4, -4],
                            iconImageHref: mediaUrl + 'blocks-desktop/b-map/i-red-dot.png'
                        },
                        placemark;

                    placemark = new ymaps.Placemark(point,
                        {},
                        options
                    );


                    if(arrival) {
                        times = BEM.I18N('b-map', 'arrival', { time: arrival });
                    }

                    if(departure) {
                        var str = BEM.I18N('b-map', 'departure', { time: departure });

                        if(arrival) {
                            times += ', ' + str;
                        } else {
                            times = str;
                        }
                    }

                    placemark.properties.set('balloonContent',
                        '<div><strong>' + name + '</strong><br/>'
                        + times
                        + (link ? ('<br />' + link) : '')
                        + '</div>');

                    map.geoObjects.add(placemark);
                });


                // Положение паровозика
                if(data.position) {
                    var icon = {
                        train: 'i-train-marker.png',
                        suburban: 'i-train-marker.png',
                        bus: 'i-bus-marker.png'
                    }[data.transportType];

                    if(icon) {
                        var placemark = new ymaps.Placemark(
                            data.position,
                            {},
                            {
                                iconImageSize: [28, 26],
                                iconImageOffset: [-9, -23],
                                iconImageHref: mediaUrl + 'blocks-desktop/b-map/' + icon
                            }
                        );

                        map.geoObjects.add(placemark);
                    }
                }
            });
        }
    }

});
