(function() {

function airportMap(name, address, lng, lat, z, lang) {
    $(function() {
        ymaps.ready(function() {
            var map = new ymaps.Map('map', {
                center: [lat, lng],
                zoom: z,
                behaviors: ['scrollZoom', 'default']
            });

            map.controls.add('typeSelector').
                        add('zoomControl');

            var domain = 'http://' + BEM.I18N('b-map', 'yandex-map-domain') + "/?",
                url = domain + $.param({
                    'll': map.getCenter().reverse().toString(),
                    'l': 'map',
                    'pt': lat + ',' + lng + ',pmbl'
                }),
                mess = BEM.I18N('b-map', 'go') ,
                airportBalloonTemplate = '<div style="overflow: auto">'
                    + '<div><strong>'+ name +'</strong></div>'
                    + '<div>'+ address +'</div>'
                    + '<div><a href="'+ url +'">'+ mess +'</a></div>'
                    + '</div>';

            map.balloon.open([lng, lat], {
                contentBody: airportBalloonTemplate
            });
        });
    });
};

BEM.DOM.decl({name: 'b-map', modName: 'type', modVal: 'station'}, {

    onSetMod: {

        js: function() {

            var params = this.params;

            airportMap(params['name'], params['address'], params['lng'], params['lat'], params['z'], params['lang']);
        }
    }
});

})();
