(function() {

var URL = BEM.blocks['i-url'];

BEM.DOM.decl({ name: 'b-maps-search', modName: 'type', modVal: 'airplanes' }, {

    onSetMod: {
        'js': function() {
            var _this = this,
                setHashMapParams,
                initial = URL.getHashParams();

            if(initial.center) {
                initial.center = $.map(initial.center.split(','), parseFloat);
            } else {
                initial.center = this.params.center;
            }

            if(initial.zoom) {
                initial.zoom = parseFloat(initial.zoom);
            } else {
                initial.zoom = this.params.zoom;
            }

            this.bindTo('submit', function(e) { _this._onSubmit(e); });

            this.airplanes = this.findBlockOutside('b-page').findBlockInside({ blockName : 'b-map', modName : 'type', modVal : 'airplanes' });
            this.inputs = {
                'number': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'number' }),
                'company': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'company' }),
                'airport': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'airport' }),
                'city': this.findBlockInside({ blockName : 'b-form-input', modName : 'mod', modVal : 'city' })
            };
            $.each(this.inputs, function(key, elem) {
                elem.val(initial[key] || '');
            });

            this.desc = this.findBlockOutside('b-page').findBlockInside('b-maps-air-desc');

            if(_this.desc) {
                this.airplanes.setRouteInfoCallback(function(data) {
                    _this.showInfo(data);
                });
            }

            setHashMapParams = function(map) {
                var center = map.getCenter();
                URL.setHashParams({
                    center: center[0] + ',' + center[1],
                    zoom: map.getZoom()
                });
            };

            BEM.channel('b-map_type_airplanes').on('bounds-change', function(e, map) {
                setHashMapParams(map);
            });

            this.airplanes.init(initial, setHashMapParams);

            this.filter();

        }
    },

    showInfo: function(route) {
        if(route) {
            var html = ('<div class="b-maps-air-desc__item"><strong>' + route.title + '</strong></div>' +
                '<div class="b-maps-air-desc__item"><a target=_blank href="' + route.url + '">' + BEM.I18N('b-maps-search', 'route', { 'route-number': route.number }) + '</a></div>' +
                '<div class="b-maps-air-desc__item">' + BEM.I18N('b-maps-search', 'distance', { distance: Math.floor(route.distance) }) + '</div>');

            if (route.arrivalIn > 0) {
                html = html + '<div class="b-maps-air-desc__item">' + BEM.I18N('b-maps-search', 'arrival-in', { 'time-left': BEM.blocks['i-time'].humanDuration(route.arrivalIn) }) + '</div>';
            } else {
                html = html + '<div class="b-maps-air-desc__item">' + BEM.I18N('b-maps-search', 'arrived') + '</div>';
            }

            this.desc.domElem.html(html).removeClass('i-hidden');
        } else {
            this.desc.domElem.addClass('i-hidden');
        }
        return true;
    },

    _onSubmit: function(e) {

        e.preventDefault();
        var filters = this.filter(true);
        URL.setHashParams(filters);

    },

    filter: function (search) {
        var _this = this,
            filters = {};

        $.each(this.inputs, function(key, elem) {
            filters[key] = elem.val()
        });

        this.airplanes.filter(filters, search, function(count) {
            if(count) {
                _this.findBlockOutside('b-page').elem('not-found').addClass('i-hidden');
            } else {
                _this.findBlockOutside('b-page').elem('not-found').removeClass('i-hidden');
            }
        });

        return filters;
    }

});

})();
