(function(){

var TIME = BEM.blocks['i-time'];

BEM.DOM.decl('b-page-calendar-legend', {

    onSetMod: {

        'js': function() {
            BEM.blocks['b-page'].on('change-tz', this._onTimeZoneChange, this);
        }
    },

    _onTimeZoneChange: function(e, tz) {
        this.redrawTimes();
        this.redrawDays(tz);
    },

    redrawTimes: function() {
        var _this = this,
            prev,
            times = $(_this.findBlocksInside('i-time'));

        times.each(function() {
            var displayTime,
                dtCopy,
                html;

            displayTime = this.displayTime();

            dtCopy = new Date(displayTime.getTime());

            html = TIME.formatTime('time', dtCopy, prev);

            $(this.domElem).html(html);

            prev = displayTime;
        })
    },

    redrawDays: function(tz) {
        var tzId = tz || 'local',
            days = $(this.findBlocksInside('i-date')),
            caution = $('.b-page-title__caution strong'),
            cautionLegend = $('.b-block__caution-legend'),
            text = days[0].params[tzId];

        caution.html(text);
        cautionLegend.html(text);

        days.each(function() {
            var html = this.params[tzId];

            $(this.domElem).html(html);
        })
    }

})

})();
