(function() {

BEM.DOM.decl({ name : 'b-preview-train-big', modName : 'editable', modVal : 'yes'}, {

    onSetMod : {

        'js' : function() {

            this._seatSize = {
                width : 23,
                height : 21
            };

            this._size = {
                width : this.elem('container').width(),
                height : this.elem('container').height()
            };

            this._thumb = this.findBlockOn(this.domElem.prev(), 'b-preview-train');

            this.bindToDoc('keypress', this._onKeyPress);

            this.input = this.findBlockInside('b-form-input');

            this.input.on('focus', function() {
                this.selectSeat();
            }, this);

            this._thumbs = [];

            this._deserialize();

            this.input.on('change', function(e, data) {
                if(!(data && data.source == 'serialize'))
                    this._deserialize();
            }, this);
        }
    },

    _onChange : function(seat) {

        var _this = this,
            data = [];

        //this._moveThumbs(data);

        this._serialize();

    },

    _deserialize : function() {

        var _this = this,
            lines = this.input.val().split('\n');

        this.findElem('seat').remove();
        this._thumb.findElem('place').remove();

        this._data = [];

        $.each(lines, function(lineno, line) {

            var match = line.match(/^( *)(.*)/),
                prefix,
                values,
                seat;

            if(match.length) {
                prefix = match[1],
                values = match[2].split(/( *, *)/),

                seat = {
                    number : values[0],
                    coords : {
                        x : parseInt(values[2]),
                        y : parseInt(values[4])
                    },
                    thumb : {
                        x : parseInt(values[6]),
                        y : parseInt(values[8])
                    },

                    _delimiters : [prefix, values[1], values[3], values[5], values[7]]
                };

                if(!isNaN(seat.coords.x) || !isNaN(seat.coords.y)) {
                    _this.addSeat(seat);
                } else {
                    _this._data.push(line);
                }
            } else {
                _this._data.push(line);
            }

        });

    },

    _serialize : function() {

        var _this = this,
            lines = [];

        $.each(this._data, function(i, seat) {

            if(typeof seat == 'string') {

                lines.push(seat);

            } else {

                var delimiters = seat._delimiters || ['', ',', ',', ',', ','],
                    thumb = _this._thumbs[seat.elem.attr('data-thumb')];

                lines.push([
                    delimiters[0],
                    _this.findElem(seat.elem, 'seat__i').html(),
                    delimiters[1],
                    parseInt(seat.elem.css('left')),
                    delimiters[2],
                    parseInt(seat.elem.css('top')),
                    delimiters[3],
                    parseInt(thumb.css('left')),
                    delimiters[4],
                    parseInt(thumb.css('top'))
                ].join(''));
            }

        });

        this.input.val(lines.join('\n'), {source: 'serialize'});

    },

    _onKeyPress : function(e) {

        var cursor = {
            37 : {x : -1, y: 0},
            38 : {x : 0, y : -1},
            39 : {x : 1, y : 0},
            40 : {x : 0, y : 1}
            },
            selected = this.findElem('seat', 'state', 'selected'),
            direction;

        if(!selected.length)
            return;

        if((direction = cursor[e.keyCode])) {

            var coords = this.seatCoords(selected);

            e.preventDefault();

            if(e.ctrlKey) {
                this.moveThumb(selected, direction);
            } else {
                this.moveSeat(selected, {
                    x: coords.x + direction.x,
                    y: coords.y + direction.y
                });
            }

        } else if(e.keyCode == 46) {

            this.findElem('seat', 'state', 'selected');

            this.deleteSeat(selected);

        }

    },

    _startDrag : function(e) {

        e.preventDefault();

        if(e.which != 1)
            return;

        var seat = e.data.domElem,
            coords = this.seatCoords(seat),
            prev = {
                x : e.pageX - coords.x,
                y : e.pageY - coords.y
            };

        this.selectSeat(seat);

        this.findElem(seat, 'seat__i').css('cursor', 'move');

        this.bindToDoc('mousemove', function(e) {
            this.moveSeat(seat, {
                x : e.pageX - prev.x,
                y : e.pageY - prev.y
            });
        });

        this.bindToDoc('mouseup', function(e) {
            this.unbindFromDoc('mousemove');
        });

    },

    seatCoords : function(seat) {

        return {
            x : parseInt(seat.css('left')),
            y : parseInt(seat.css('top'))
        };

    },

    moveThumb : function(seat, direction) {

        var thumb = this._thumbs[seat.attr('data-thumb')],
            coords = {
                x : parseInt(thumb.css('left')),
                y : parseInt(thumb.css('top'))
            };

        thumb.css({
            left : coords.x + direction.x,
            top: coords.y + direction.y
        });

        this._onChange(seat);

    },

    moveSeat : function(seat, coords) {

        if(!seat.length)
            return;

        if(coords.x < 0)
            coords.x = 0;

        if(coords.x + this._seatSize.width >= this._size.width)
            coords.x = this._size.width - this._seatSize.width - 1;

        if(coords.y < 0)
            coords.y = 0;

        if(coords.y + this._seatSize.height >= this._size.height)
            coords.y = this._size.height - this._seatSize.height - 1;

        seat.css({
            left : coords.x,
            top : coords.y
        });

        this._onChange(seat);

    },

    editSeat : function(seat) {

        var numberElem = this.findElem(seat, 'seat__i'),
            number;

        number = numberElem.html();

        number = window.prompt('Номер места', number);

        if(number) {
            numberElem.html(number);

            this._onChange(seat);
        }

    },

    deleteSeat : function(seat) {

        this._thumbs[seat.attr('data-thumb')].remove();

        seat.remove();

        var index = $.inArray(seat[0], $.map(this._data, function(seat) {
            if(typeof seat == 'string')
                return {};
            else
                return seat.elem[0];
        }));

        this._data.splice(index, 1);

        this._onChange(seat);

    },

    selectSeat : function(seat) {

        this.setMod(this.findElem('seat'), 'state', 'white');

        this._thumb.setMod(this._thumb.findElem('place'), 'state', 'white');

        if(seat) {
            this.setMod(seat, 'state', 'selected');

            var thumb = this._thumbs[seat.attr('data-thumb')];

            this._thumb.setMod(thumb, 'state', 'busy');
        }

    },

    addSeat : function(seat) {

        var thumb;

        seat.elem = $(BEM.HTML.build({
            block : this.__self._name,
            elem : 'seat',
            mods : { state : 'white' },
            content: {
                elem: 'seat__i',
                tag: 'span',
                content: seat.number
            }
        }));

        seat.elem.css({
            left : seat.coords.x,
            top : seat.coords.y
        });

        this.elem('container').append(seat.elem);

        thumb = $(BEM.HTML.build({
            block: this._thumb.__self._name,
            elem: 'place',
            mods: { state : 'white' }
        }));

        thumb.appendTo(this._thumb.domElem);

        seat.elem.attr('data-thumb', this._thumbs.length);

        this._thumbs.push(thumb);

        thumb.css({
            left : seat.thumb.x,
            top: seat.thumb.y
        });

        this._data.push(seat);

        return seat.elem;

    }

}, {
    live : function() {

        this.liveBindTo('seat', 'dblclick', function(e) {

            e.preventDefault();
            e.stopPropagation();

            this.editSeat(e.data.domElem);

        });

        this.liveBindTo('seat', 'mousedown', function(e) {
            this._startDrag(e);

            return false;
        });

        this.liveBindTo('seat', 'click', function(e) {
            e.stopPropagation();
        });

        this.liveBindTo('container', 'click', function(e) {
            this.selectSeat();
        });

        this.liveBindTo('container', 'dblclick', function(e) {

            var number = window.prompt('Номер места'),
                seat,
                elem;

            if(!number)
                return;

            seat = {
                number : number,
                coords : {
                    x : e.layerX,
                    y : e.layerY
                },
                thumb : {
                    x : 0,
                    y : 0
                }
            };

            elem = this.addSeat(seat);

            this.selectSeat(elem);

            this._onChange(seat);

        });

        return false;
    }
});

})();