(function() {

BEM.DOM.decl('b-preview-train-big', {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            var row = this.domElem.closest(BEM.DOM.blocks['b-pricetable'].buildSelector('row')),
                mainRow = row.prev(),
                thumbs;

            this.form = this.findBlockOutside('b-form');

            this.rulesData = this.findBlockOutside('b-pricetable').elemParams(mainRow)['rules-data'];

            this._thumb = this.findBlockInside(mainRow, 'b-preview-train');

            this._initSeats();

            if (this.params.seatSelectionAlgo === 'two-level') {
                this._initTwoLevelSeats();
            }

            this.on('show', this._onShow);

            this.on('seatsChange', this._onSeatsChange);

            this.on('sexChange', this._onSexChange);

        }

    },

    _onShow: function() {
        if (this.params.seatSelectionAlgo === 'two-level') {
            this.restrictSelectableToConfigurations();
        }

        this._updateSeatsVisuals();

        this._updateSumm();
    },

    _initSeats: function() {
        var cats = this.params.seats;

        this._seatsElements = $.makeArray(this.findElem(this.elem('container'), 'seat'));

        var seats = this._seatsElements.map(function (e) {
            var domElem = $(e);
            var number = this.elemParams(domElem);
            var state = this.getMod(domElem, 'state');
            var free = cats.free.indexOf(number) !== -1;

            var seat = {
                number: number,
                intNumber: parseInt(number),
                domElem: domElem,
                free: free,
                available: state === 'white',
                selectable: state === 'white',
                selected: false
            };

            this.bindTo(domElem, 'click', function (e) {
                e.preventDefault();

                this._onSeatClick(seat);
            });

            return seat;
        }, this);

        seats.sort(function (a, b) {
            return a.intNumber - b.intNumber;
        });

        this._seats = seats;
    },

    _updateSeatsVisuals: function() {
        this._seats.forEach(function(seat) {
            var stateVal;

            if (seat.selected) {
                stateVal = 'selected';
            } else if (seat.selectable) {
                stateVal = 'white';
            } else if (seat.available) {
                stateVal = 'free';
            } else if (!seat.free) {
                stateVal = 'busy';
            } else {
                stateVal = 'deny';
            }

            this.setMod(seat.domElem, 'state', stateVal);
        }, this);
    },

    _initTwoLevelSeats: function () {
        this._seats.forEach(function (seat) {
            var off0 = seat.intNumber - 1;
            var level = off0 % 2; // Нечетные - нижние (0)

            var remainder = off0 % 2;
            var column = (off0 - remainder) / 2;

            seat.level = level;
        }, this);
    },

    twoLevelSeatsConfigurations: {
        1: ["1+0", "0+1"],
        2: ["1+1", "2+0", "0+2"],
        3: ["1+2", "2+1", "0+3"],
        4: ["1+3", "2+2", "0+4"]
    },

    restrictSelectableToConfigurations: function() {
        this._seats.forEach(function (seat) {
            seat.selectable = false;
        });

        var q = this.form.getQuantities();

        var occupied = q.adults + q.children;

        var configurations = this.twoLevelSeatsConfigurations[occupied];

        var available = this._seats.filter(function (seat) { return seat.available; });
        var selected = this._seats.filter(function (seat) { return seat.selected; });

        configurations.forEach(function (conf) {
            var levelsCounts = conf.split("+").map(function (n) { return parseInt(n); });
            var firstSeat, remainingCounts, confSeats, seatIndex, seat, confSelected;

            for (firstSeat = 0; firstSeat < available.length; firstSeat++) {
                remainingCounts = levelsCounts.slice();
                confSeats = [];

                for (seatIndex = firstSeat; seatIndex < available.length; seatIndex++) {
                    seat = available[seatIndex];

                    if (remainingCounts[seat.level] > 0) {
                        remainingCounts[seat.level]--;
                        confSeats.push(seat);
                    }

                    if (remainingCounts.every(function (count) { return count <= 0; })) {
                        confSelected = confSeats.filter(function (seat) { return seat.selected; });

                        if (confSelected.length === selected.length) {
                            confSeats.forEach(function (seat) {
                                seat.selectable = true;
                            });
                        }

                        break;
                    }
                }

            }

        }, this);
    },

    twoLevelSeatSelector: function (seat) {
        var q = this.form.getQuantities();

        seat.selected = !seat.selected;

        this.restrictSelectableToConfigurations();
    },

    oldSeatSelector: function (seat) {
        var q = this.form.getQuantities();
        var occupied = q.adults + q.children;
        var selected = this._seats.filter(function (seat) { return seat.selected; });
        var selectable = this._seats.filter(function (seat) { return seat.selectable; });

        if (occupied > selectable.length) {
            return;
        }

        var position = selectable.indexOf(seat);

        if (position + occupied > selectable.length) {
            position = Math.max(selectable.length - occupied, 0);
        }

        selected.forEach(function (seat) { seat.selected = false; });

        selected = selectable.slice(position, position + occupied);

        selected.forEach(function (seat) {
            seat.selected = true;
        });
    },

    _onSeatClick: function (seat) {
        if (seat.selectable) {
            var q = this.form.getQuantities();

            if (this.params.seatSelectionAlgo === 'two-level') {
                this.twoLevelSeatSelector(seat);
            } else {
                this.oldSeatSelector(seat);
            }

            this._updateSeatsVisuals();

            this._updateSumm();
        }
    },

    _updateSumm: function () {
        var selected = this._seats.filter(function (seat) { return seat.selected; });
        var someSelectable = this._seats.some(function (seat) { return seat.selectable; });
        var available = this._seats.filter(function (seat) { return seat.available; });

        /* FIXME */
        var q = this.form.getQuantities();

        var occupied = q.adults + q.children;

        if(selected.length === occupied) {
            var data = this.form.getData();

            this.form.setTotal(data, {selected: selected});
        } else if (occupied > available.length) {
            this.form.summ.showError(BEM.I18N('b-form', 'order-insufficient-seats-amount'));
        } else if (someSelectable) {
            this.form.summ.clear();
        } else {
            this.form.summ.showError(BEM.I18N('b-form', 'order-configuration-not-available'));
        };
    },

    _onSeatsChange : function(e) {
        this._seats.forEach(function (seat) {
            seat.selected = false;
        });

        if (this.params.seatSelectionAlgo === 'two-level') {
            this.restrictSelectableToConfigurations();
        }

        this._updateSeatsVisuals();

        this._updateSumm();
    },

    _onSexChange : function(e, sex) {

        var _this = this,
            allSeats = this.findElem(this.elem('container'), 'seat')
                           .not(this.buildSelector('seat', 'state', 'busy')),
            selected = this.findElem('seat', 'state', 'selected').eq(0),
            available,
            seats = this.params.seats;

        this._seats.forEach(function (seat) {
            seat.selected = false;
        });

        if(sex == 'any') {
            available = seats.mixed.concat(seats.sex);
        } else if(sex == 'male') {
            available = seats.male.concat(seats.sex);
        } else if(sex == 'female') {
            available = seats.female.concat(seats.sex);
        } else if(sex == 'mixed') {
            available = seats.mixed.concat(seats.sex);
        } else {
            throw 'Unknown sex ' + sex;
        }

        this._seats.forEach(function (seat) {
            seat.available = available.indexOf(seat.number) !== -1;
            seat.selectable = seat.available;
        });

        if (this.params.seatSelectionAlgo === 'two-level') {
            this.restrictSelectableToConfigurations();
        }

        this._updateSeatsVisuals();

        if(this._thumb) {
            var thumbs = this._thumb.findElem('place');

            this._seats.forEach(function (seat, i) {
                var thumb = thumbs.eq(i);

                var state = seat.available ? 'white' : 'busy';

                this._thumb.setMod(thumb, 'state', state);

            }, this);
        }

        this._updateSumm();

    }

});

})();
