(function() {

var AJAX = BEM.blocks['i-ajax'],
    URL = BEM.blocks['i-url'];

BEM.DOM.decl({ name : 'b-pricetable', modName : 'type', modVal : 'ucus'}, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            this._form = this.findBlockOutside('b-form');

            this.retrieving = 0;

            if(this.getMod('incomplete') == 'yes') {
                this.startAjaxUpdates();
            }

        }

    },

    runCandy: function() {
        BEM.DOM.update(this.elem('cell', 'type', 'fiyat'), BEMHTML.apply({ 'block': 'b-candy' }));
    },

    startAjaxUpdates: function(query) {
        this.runCandy();

        if(typeof query == 'undefined') {
            query = window.location.search + '&show_pre=1';
        }

        var _this = this,
            retId = this.retrieving + 1;

        this.retrieving += 1;

        AJAX.progress(function(finish) {

            $.ajax({
                url: 'ucus_fiyat/' + query,
                dataType: 'json',
                timeout: 5000,
                success: function (response, textStatus) {
                    if(retId < _this.retrieving) {
//                        console.log('finish as obsolete');
                        finish();
                        return;
                    }
                    if(response == 'error') {
                        window.location = window.location;
                    } else if(response == 'retrieving') {
                    } else {
                        BEM.DOM.update(_this.elem('cell', 'type', 'fiyat'), BEMHTML.apply(response));

                        _this.dropElemCache();

                        if(_this.getRadioChoice().length) {
                            _this._form.buy_button.domElem.removeClass('i-hidden');
                        }

                        finish();
                    }
                }
            });

        }, function() {
        });

    },

    getRadioChoice : function() {

        return this.elem('radio').filter('[checked]');

    },

    onQuantityChange : function(quantities) {

        this._form.buy_button.domElem.addClass('i-hidden');
        BEM.DOM.update(this.elem('cell', 'type', 'fiyat'), BEMHTML.apply({ 'block': 'b-candy' }));

        var query = URL.changeParams(window.location.search, {
            n_adult: quantities.adults,
            n_child: quantities.children,
            n_infant: quantities.infants
        });
        this.startAjaxUpdates(query);

    }

});

})();
