BEM.decl('b-rasp-search__dataprovider', {

    onSetMod : {

        'js' : function() {

            this._form = this.params.input.findBlockOutside(this.params.form || 'b-rasp-search');
            this._cache = {};
            this.field = this.params.field;
            this.otherField = this.field == 'from' ? 'to' : 'from';

        }
    },

    get: function(val, onSuccess) {

        var _this = this;

        var params = {
            format: 'old',
            field: this.field,
            query: this._form[this.field].val(),
            other_query: this._form[this.otherField].val(),
            other_point: this._form[this.otherField].keyVal(),
            limit: 11
        };

        $.extend(params, this.params['user-params']);

        var searchType = this._form.searchType;
        var suggestType;

        if (searchType === 'all') {
            suggestType = 'all_suggests';
        } else if (searchType === 'suburban') {
            suggestType = 'suburban';
        } else {
            suggestType = 'by_t_type';
            params.t_type_code = searchType;
        }

        var url = this.params['suggest-url'] + suggestType + '?callback=?';

        var cacheKey = url + '&' + $.param(params, true);

        var startRequests = false;
        var suggestsData = this._cache[cacheKey];

        if (!suggestsData) {
            startRequests = true;

            suggestsData = this._cache[cacheKey] = {};
        }

        if (suggestsData.items) {
            // Уже есть саггесты
            onSuccess.call(this.params.callbackCtx, suggestsData);
        }

        // Если запись есть в кэше, значит запросы уже идут
        if (!startRequests) {
            return;
        }

        $.getJSON(url, params, function(data) {

            var items = data[1];

            suggestsData._showLink = items.length > 10;
            suggestsData.items = items.slice(0, 10);

            if (suggestsData._showLink) {
                suggestsData.link = suggestsData._link;
            }

            onSuccess.call(_this.params.callbackCtx, suggestsData);

        });

        var validateParams = {
            searchType: searchType,
            fromName: this._form.from.val(),
            fromId: this._form.from.keyVal(),
            toName: this._form.to.val(),
            toId: this._form.to.keyVal()
        };

        $.getJSON('/search/validate/?callback=?', validateParams, function (data) {
            if (data.form.valid) {
                suggestsData._link = _this._form.link([
                    {name: 'suggest', value: _this.field}
                ]);

                if (suggestsData.items && suggestsData._showLink) {
                    suggestsData.link = suggestsData._link;
                    onSuccess.call(_this.params.callbackCtx, suggestsData);
                }
            }
        });

    }

});
