BEM.DOM.decl('b-sch-print', {

    onSetMod: {

        'js': function() {

            var _this = this;

            this.stationsLimit = 3;
            this.disableByDirection = true;
            this.baseUrl = '/print/helpers/';
            this.zone = this.params['zone_id'];
            this.reversedRadio = this.findBlockInside({blockName: 'b-form-radio', modName: 'mod', modVal: 'reversed'});

            this.bindDirections();

            $.each(['from', 'to'], function(y, direction) {
                $.each([false, true], function(x, selected) {
                    _this.bindTo(_this.getStationsSelect(direction, selected), 'change', function() {
                        _this.fixArrow(direction, selected ? 'remove' : 'add');
                    });
                });
            });

            this.bindTo(this.elem('tab'), 'click', function(e) {
                _this.delMod(this.elem('tab'), 'state', 'current');
                _this.setMod(e.data.domElem, 'state', 'current')
            });

            this.bindTo(this.elem('submit'), 'click', function(e) {
                if(_this.hasMod(e.data.domElem, 'disabled', 'yes')) {
                    return;
                }

                var params = {
                        stationsFrom: $('option', this.getStationsSelect('from', true)).map(function () { return this.value; }).get(),
                        stationsTo: $('option', this.getStationsSelect('to', true)).map(function () { return this.value; }).get(),
                        print: ''
                    },
                    location = window.location;

                if(_this.elemParams(_this.elem('tab', 'state', 'current'))['next_plan'])
                    params['nextPlan'] = '';

                window.open('http://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70472/*'
                    + location.protocol + '//' + location.host + location.pathname
                    + '?' + $.param(params, true));
            });

            this.reversedRadio.bindTo('change', function(e) {
                var reversedChildren = function($q) {
                        var q = $q.children().get();
                        q.reverse();
                        return $(q);
                    },
                    $sf = reversedChildren(_this.getStationsSelect('from', false)),
                    $st = reversedChildren(_this.getStationsSelect('to', false)),
                    $sfs = reversedChildren(_this.getStationsSelect('from', true)),
                    $sts = reversedChildren(_this.getStationsSelect('to', true));

                _this.getStationsSelect('from', false).append($st).hide().show();
                _this.getStationsSelect('to', false).append($sf).hide().show();
                _this.getStationsSelect('from', true).append($sts).hide().show();
                _this.getStationsSelect('to', true).append($sfs).hide().show();

                _this.fixArrow('from', 'add');
                _this.fixArrow('from', 'remove');
                _this.fixArrow('to', 'add');
                _this.fixArrow('to', 'remove');

            });

            BEM.blocks['b-page'].on('change-city', function(e, data) {

                _this.zone = data.id;
                _this.findBlockOutside('b-page').findBlockInside({blockName: 'b-text', modName: 'mod', modVal: 'city-name'}).domElem.text(data.title)

                $.getJSON(_this.baseUrl + 'directions', _this._marktrans({ 'zone': data.id }),
                    function(directions) {

                        directions.push({id: '', name: BEM.I18N('b-sch-print', 'all-directions')});

                        var last_index = directions.length - 1,
                            bemjson = $.map(directions, function(d, j) {
                                return [
                                    (j == 0 ? '&nbsp;' : ''),
                                    {
                                        'block': 'b-sch-print',
                                        'elem': 'trip',
                                        'js': { 'id': d.id },
                                        'content': [
                                            {
                                                'block': 'b-link',
                                                'mods': { 'pseudo': 'yes' },
                                                'url': '#',
                                                'content': d.name
                                            },
                                            j < last_index ? { 'elem': '3pt', 'tag':'span', 'content': ',' } : ''
                                        ]
                                    }
                                ];
                            }),
                            html = BEMHTML.apply(bemjson);

                        _this.elem('trips').html(html);

                        _this.bindDirections();

                        // Подгрузить станции первого направления
                        _this.findBlockInside(_this.findElem('trip'), 'b-link').domElem.click()

                    }
                );

            });

            _this.bindTo(_this.elem('arrow', 'mod', 'from-add'), 'click', function() {_this.arrowClick('from', 'add')});
            _this.bindTo(_this.elem('arrow', 'mod', 'from-remove'), 'click', function() {_this.arrowClick('from', 'remove')});
            _this.bindTo(_this.elem('arrow', 'mod', 'to-add'), 'click', function() {_this.arrowClick('to', 'add')});
            _this.bindTo(_this.elem('arrow', 'mod', 'to-remove'), 'click', function() {_this.arrowClick('to', 'remove')});

            $(_this.getStationsSelect('from', false)).bind('dblclick', function() { _this.arrowClick('from', 'add'); });
            $(_this.getStationsSelect('from', true)).bind('dblclick', function() { _this.arrowClick('from', 'remove'); });
            $(_this.getStationsSelect('to', false)).bind('dblclick', function() { _this.arrowClick('to', 'add'); });
            $(_this.getStationsSelect('to', true)).bind('dblclick', function() { _this.arrowClick('to', 'remove'); });

        }
    },

    bindDirections: function() {
        var _this = this;
        this.bindTo(this.findElem('trip'), 'click', function(e) {
            var elemParams = _this.elemParams(e.data.domElem),
                direction = elemParams.id;

            _this.delMod(_this.findElem('trip'), 'state', 'current')
            _this.setMod(e.data.domElem, 'state', 'current')

            $.getJSON(_this.baseUrl + 'stations', _this._marktrans({
                    direction: direction,
                    zone: _this.zone
                }),
                function(stations) {

                    _this.setMod(_this.elem('submit'), 'disabled', 'yes')

                    _this.getStationsSelect('from', true).empty();
                    _this.getStationsSelect('to', true).empty();

                    if ($.browser.webkit) {
                        _this.elem('multiple').scrollTop(0);
                    }

                    _this.reversedRadio.val('false');

                    var bemjson = $.map(stations, function(s, j) {
                            return {
                                'block': 'b-sch-print',
                                'elem': 'multiple-option',
                                'value': s.id,
                                'content': s.name,
                                'js': { 'order': j }
                            }
                        }),
                        html = BEMHTML.apply(bemjson);

                    _this.getStationsSelect('from', false).html(html).hide().show();
                    _this.getStationsSelect('to', false).html(html).hide().show();
                    _this.getStationsSelect('from', true).hide().show();
                    _this.getStationsSelect('to', true).hide().show();

                    if (!$.browser.msie) {
                        _this.fixArrow('from', 'add');
                        _this.fixArrow('from', 'remove');
                        _this.fixArrow('to', 'add');
                        _this.fixArrow('to', 'remove');
                    }

                    if(direction) {
                        _this.stationsLimit = 3;
                        _this.disableByDirection = true;
                    } else {
                        _this.stationsLimit = 1;
                        _this.disableByDirection = false;
                    }
                }
            );
        });
    },

    getStationsSelect: function(direction, selected) {
        var mod = 'stations-' + direction;
        if(selected)
            mod += '-selected';
        return this.findElem('multiple', 'mod', mod);
    },

    fixArrow: function(direction, action) {
        var type = action == 'add' ? 'right' : 'left',
            arrow = this.elem('arrow', 'mod', direction + '-' + action),
            disable = false;

        if(action == 'add') {
            disable = $('option:selected', this.getStationsSelect(direction, false)).length == 0 || $('option', this.getStationsSelect(direction, true)).length >= this.stationsLimit;
        } else {
            disable = $('option:selected', this.getStationsSelect(direction, true)).length == 0;
        }

        this.setMod(arrow, 'type', type + (disable ? '-disabled' : ''));
    },

    enableOptions: function($options) {
        $options.attr('disabled', false);
    },

    disableOptions: function($options) {
        $options.attr('selected', false);
        $options.attr('disabled', true);
    },

    arrowClick: function(direction, action) {
        var _this = this,
            $from = _this.getStationsSelect(direction, false),
            $to = _this.getStationsSelect(direction, true),
            $children,
            $selected,
            tmp;

        if(action == 'remove') {
            tmp = $to;
            $to = $from;
            $from = tmp;
        }

        $selected = $from.find('option:selected');

        $children = $to.children();

        if(action == 'add') // В выбранные можно добавлять не больше трех станций
            $selected = $selected.slice(0, _this.stationsLimit - $children.length);

        // Добавляем элементы в target, выдерживая порядок по order с учетом reverse
        $children.each(function(x, child) {
            var $target = $(child),
                tOrder = _this.getOrder($target);

            $.each($selected, function(y, item) {
                var $item = $(item);

                if(_this.getOrder($item) < tOrder) {
                    $target.before($item);
                    $selected = $selected.slice(1);
                }
            });
        });

        if($selected.length) {
            // Если остались элементы, их нужно запихать в конец списка
            $to.append($selected);
        }

        _this.applyWizardry(direction);

        _this.getStationsSelect(direction, false).hide().show();
        _this.getStationsSelect(direction, true).hide().show();

        _this.fixArrow(direction, 'add');
        _this.fixArrow(direction, 'remove');

        if(_this.getStationsSelect('from', true).find('option').length && _this.getStationsSelect('to', true).find('option').length) {
            _this.delMod(_this.elem('submit'), 'disabled', 'yes');
        } else {
            _this.setMod(_this.elem('submit'), 'disabled', 'yes');
        }
    },

    getOrder: function(elem) {
        elem = $(elem);
        if(!elem.length) {
            return 0;
        }
        var order = this.elemParams(elem).order;
        if(this.reversedRadio.val() == 'true') {
            order *= -1;
        }
        return order;
    },

    applyWizardry: function(direction) {
        var _this = this,
            otherDirection = direction == 'from' ? 'to' : 'from',
            $master = _this.getStationsSelect(direction, true).find('option'),
            $slave = _this.getStationsSelect(otherDirection, false),
            $slaveOptions = $slave.find('option'),
            $slaveSelected = _this.getStationsSelect(otherDirection, true).find('option'),
            rangeFrom = _this.getOrder($master.eq(0)),
            rangeTo = _this.getOrder($master.eq($master.length - 1)),
            $badSelected = $([]),
            test;

        if(!_this.disableByDirection) {
            test = function(o) { return o == rangeTo; };
        } else if(direction == 'from') {
            test = function(o) { return o <= rangeTo; };
        } else {
            test = function(o) { return o >= rangeFrom; };
        }

        $slaveSelected.each(function (j, elem) {
            if($master.length && test(_this.getOrder(elem))) {
                $badSelected.push(elem);
            }
        });

        _this.disableOptions($badSelected);

        $slaveOptions.each(function(x, slaveElem) {
            var $slaveElem = $(slaveElem),
                slaveOrder = _this.getOrder(slaveElem);

            $badSelected.each(function (y, badElem) {
                if(_this.getOrder(badElem) < slaveOrder) {
                    $slaveElem.before(badElem);
                    $badSelected = $badSelected.slice(1);
                };
            });

            if($master.length && test(slaveOrder))
                _this.disableOptions($slaveElem);
            else
                _this.enableOptions($slaveElem);
        });

        $slave.append($badSelected);

        _this.fixArrow(otherDirection, 'add');
        _this.fixArrow(otherDirection, 'remove');
    },

    _marktrans: function(params) {
        var current = BEM.blocks['i-url'].parseQuery(window.location.search);

        if (current.marktrans) {
            params.marktrans = 't';
        }

        return params;
    }

});
