(function() {

BEM.DOM.decl({ block: 'b-timetable', modName: 'filter', modVal: 'hidden' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
            this.initFilter();
        }
    },

    initFilter: function() {
        var _this = this,
            showHidden = this.elem('show-hidden'),
            links;

        if (!showHidden.length) {
            return;
        }

        links = this.findBlocksInside(showHidden, 'b-link');

        this.showHidden = links[0].hasMod('visibility', 'hidden');

        $.each(links, function(i, link) {
            link.on('click', function() {
                $.each(links, function(i, link) { link.toggleMod('visibility', 'hidden'); });

                _this.showHidden = links[0].hasMod('visibility', 'hidden');
                _this.filter();
            });
        });
    },

    filter: function() {
        var goneRows = this.elem('row', 'gone', 'yes');
        goneRows.toggleClass('i-hidden', !this.showHidden);

        // показываем даты у первых видимых элементов
        this.redrawDates();
    }
});

})();
