<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-trip">
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:b-trip"/>
    </table>
</xsl:template>

<xsl:template match="lego:hrow | lego:row" mode="lego:b-trip">
    <tr>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="lego:gap | lego:column" mode="lego:b-trip"/>
    </tr>
</xsl:template>

<xsl:template match="lego:l-layout[lego:hrow] | lego:l-layout[lego:row]" mode="lego:b-trip">
    <xsl:apply-templates select="lego:hrow | lego:row" mode="lego:b-trip"/>
</xsl:template>

<xsl:template match="lego:gap" mode="lego:b-trip">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <i></i>
    </td>
</xsl:template>

<xsl:template match="lego:column" mode="lego:b-trip">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<xsl:template match="lego:gap | lego:column" mode="lego:block-attributes">
    <xsl:copy-of select="@colspan | @rowspan"/>
    <xsl:apply-imports/>
</xsl:template>

</xsl:stylesheet>
