(function() {

var TIME = BEM.blocks['i-time'];

BEM.DOM.decl('b-tz-time', {

    // TODO: скрестить с i-time

    onSetMod: {

        js: function() {

            this.times = $.map(this.params.times, function(param) {

                return {
                    local: new Date(param.local + ' UTC'),
                    shifts: param.shifts
                };

            });

        }

    },

    redraw: function() {

        var tzId = BEM.blocks['b-page'].timeZone,
            times,
            formatted;

        times = $.map(this.times, function(t) {

            if(!tzId)
                return t.local;

            var shift = t.shifts[tzId];

            return new Date(t.local.getTime() + shift * 60000);

        });

        formatted = TIME.formatTime.apply(TIME, [this.params.format].concat(times));

        this.domElem.html(formatted);

    }

},
{

    live: function() {

        BEM.blocks['b-page'].on('change-tz', function(e) {

            $.each(e.block.findBlocksInside('b-tz-time'), function() {
                this.redraw();
            });

        });

    }

});

})();
