(function() {

function padTwo(n) {
    return n < 10 ? '0' + n : n;
}

function dateEqual(d1, d2) {
    return (d1.getUTCDate() == d2.getUTCDate() &&
            d1.getUTCMonth() == d2.getUTCMonth() &&
            d1.getUTCFullYear() == d2.getUTCFullYear());
}

var formatters = {

    ru: {

        monthNames: {
            straight: ['январь', 'февраль', 'март', 'апрель', 'май', 'июнь', 'июль', 'август', 'сентябрь', 'октябрь', 'ноябрь', 'декабрь'],
            inflected: ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря']
        },

        weekdayNames: ['понедельник', 'вторник', 'среда', 'четверг', 'пятница', 'суббота', 'воскресенье'],

        format: function(dt, fmt) {
            if(dt.fuzzy) {
                fmt = fmt.replace(/%H/g, '~%H');
            }

            var inflected = /%d(\s|&nbsp;| )+%B/.test(fmt),
                monthNames = this.monthNames[inflected ? 'inflected': 'straight'],
                components;

            var day = dt.getUTCDate();
            var month = dt.getUTCMonth();

            components = {
                d: inflected ? day : padTwo(day),
                A: this.weekdayNames[(dt.getUTCDay() + 6) % 7],
                B: monthNames[month],
                Y: dt.getUTCFullYear(),
                H: padTwo(dt.getUTCHours()),
                M: padTwo(dt.getUTCMinutes()),
                m: padTwo((month + 1))
            };

            return fmt.replace(/%([dABYHMm])/g, function (str, fmtSym) {
                return components[fmtSym];
            });

        },

        formatters: {
            'date-time': function (dt) {
                return this.format(dt, '%d %B, %H:%M');
            },
            'date-strong-time': function (dt) {
                return this.format(dt, '%d %B, <strong>%H:%M</strong>');
            },
            'time': function (dt) {
                return this.format(dt, '%H:%M');
            },
            'time-strong': function (dt) {
                return this.format(dt, '<strong>%H:%M</strong>');
            },
            'date': function (dt) {
                return this.format(dt, '%d %B');
            },
            'range': function (data) {
                var from = data.from;
                var to = data.to;

                if(from.getTime() == to.getTime()) {
                    return this.format(from, '%d %B, %H:%M');
                }

                if(dateEqual(from, to)) {
                    return this.format(from, '%d %B') + ' с ' + this.format(from, '%H:%M') + ' по ' + this.format(to, '%H:%M');
                }

                return 'c ' + this.format(from, '%d %B %H:%M') + ' по ' + this.format(to, '%d %B %H:%M');
            },
            'time-strong-date-if-changed': function(dt, prev) {
                if(prev) {
                    if(dateEqual(dt, prev)) {
                        return this.format(dt, '<strong>%H:%M</strong>');
                    }
                }

                return this.format(dt, '<strong>%H:%M</strong>, %d %B');
            }

        }

    },

    tr: {

        weekdayNames: [ 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar' ],

        format: function(dt, fmt) {
            if(dt.fuzzy) {
                fmt = fmt.replace(/%H/g, '~%H');
            }

            var dontPad = /%d(\s|&nbsp;| )+%B/.test(fmt),
                monthNames = [ 'Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık' ],
                components;

            var day = dt.getUTCDate();
            var month = dt.getUTCMonth();

            components = {
                d: dontPad ? day : padTwo(day),
                A: this.weekdayNames[(dt.getUTCDay() + 6) % 7],
                B: monthNames[month],
                Y: dt.getUTCFullYear(),
                H: padTwo(dt.getUTCHours()),
                M: padTwo(dt.getUTCMinutes()),
                m: padTwo(month + 1)
            };

            return fmt.replace(/%([dABYHMm])/g, function (str, fmtSym) {
                return components[fmtSym];
            });

        },

        formatters: {
            'date-time': function (dt) {
                return this.format(dt, '%d %B, %H:%M');
            },
            'date-strong-time': function (dt) {
                return this.format(dt, '%d %B, <strong>%H:%M</strong>');
            },
            'time': function (dt) {
                return this.format(dt, '%H:%M');
            },
            'time-strong': function (dt) {
                return this.format(dt, '<strong>%H:%M</strong>');
            },
            'date': function (dt) {
                return this.format(dt, '%d %B');
            },
            'range': function (data) {
                var from = data.from;
                var to = data.to;

                if(from.getTime() == to.getTime()) {
                    return this.format(from, '%d %B, %H:%M');
                }

                if(dateEqual(from, to)) {
                    return this.format(from, '%d %B') + ' from ' + this.format(from, '%H:%M') + ' to ' + this.format(to, '%H:%M');
                }

                return 'from ' + this.format(from, '%d %B %H:%M') + ' to ' + this.format(to, '%d %B %H:%M');
            },
            'time-strong-date-if-changed': function(dt, prev) {
                if(prev) {
                    if(dateEqual(dt, prev)) {
                        return this.format(dt, '<strong>%H:%M</strong>');
                    }
                }

                return this.format(dt, '<strong>%H:%M</strong>, %d %B');
            }

        }

    },

    uk: {

        monthNames: {
            straight: BEM.blocks['i-time-translations'].monthsTranslations.getLowerCaseList('uk', 'n'),
            inflected: BEM.blocks['i-time-translations'].monthsTranslations.getLowerCaseList('uk', 'g')
        },

        weekdayNames: BEM.blocks['i-time-translations'].daysTranslations.getLowerCaseList('uk', 'n'),

        format: function(dt, fmt) {
            if(dt.fuzzy) {
                fmt = fmt.replace(/%H/g, '~%H');
            }

            var inflected = /%d(\s|&nbsp;| )+%B/.test(fmt),
                monthNames = this.monthNames[inflected ? 'inflected': 'straight'],
                components;

            var day = dt.getUTCDate();
            var month = dt.getUTCMonth();

            components = {
                d: inflected ? day : padTwo(day),
                A: this.weekdayNames[(dt.getUTCDay() + 6) % 7],
                B: monthNames[month],
                Y: dt.getFullYear(),
                H: padTwo(dt.getUTCHours()),
                M: padTwo(dt.getUTCMinutes()),
                m: padTwo(month + 1)
            };

            return fmt.replace(/%([dABYHMm])/g, function (str, fmtSym) {
                return components[fmtSym];
            });

        },

        formatters: {
            'date-time': function (dt) {
                return this.format(dt, '%d %B, %H:%M');
            },
            'date-strong-time': function (dt) {
                return this.format(dt, '%d %B, <strong>%H:%M</strong>');
            },
            'time': function (dt) {
                return this.format(dt, '%H:%M');
            },
            'time-strong': function (dt) {
                return this.format(dt, '<strong>%H:%M</strong>');
            },
            'date': function (dt) {
                return this.format(dt, '%d %B');
            },
            'range': function (data) {
                var from = data.from;
                var to = data.to;

                if(from.getTime() == to.getTime()) {
                    return this.format(from, '%d %B, %H:%M');
                }

                if(dateEqual(from, to)) {
                    return this.format(from, '%d %B') + ' з ' + this.format(from, '%H:%M') + ' по ' + this.format(to, '%H:%M');
                }

                return 'з ' + this.format(from, '%d %B %H:%M') + ' по ' + this.format(to, '%d %B %H:%M');
            },
            'time-strong-date-if-changed': function(dt, prev) {
                if(prev) {
                    if(dateEqual(dt, prev)) {
                        return this.format(dt, '<strong>%H:%M</strong>');
                    }
                }

                return this.format(dt, '<strong>%H:%M</strong>, %d %B');
            }

        }

    }

};

BEM.DOM.decl('i-time', {

    onSetMod: {

        js: function() {

            this.local = new Date(this.params.local + ' UTC');

            if(this.params.fuzzy) {
                this.local.fuzzy = true;
            }

            this.tzTimes = {};

        }

    },

    displayTime: function() {

        var tzId = BEM.blocks['b-page'].timeZone;

        if(!tzId)
            return this.local;

        if(!(tzId in this.tzTimes)) {

            var shift = this.params.shifts[tzId];

            this.tzTimes[tzId] = new Date(this.local.getTime() + shift * 60000);

            if(this.params.fuzzy) {
                this.tzTimes[tzId].fuzzy = true;
            }
        }

        return this.tzTimes[tzId];

    }

},
 {
    live: true,

    formatTime: function(format) {

        var formatterArgs = Array.prototype.slice.call(arguments, 1),
            lang = BEM.blocks['i-global'].param('lang'),
            langFormatter = formatters[lang],
            formatter = langFormatter.formatters[format] || function (dt) {
                return this.format(dt, format);
            };

        return formatter.apply(langFormatter, formatterArgs);

    },

    dateEqual : dateEqual,

    addDays : function(date, d) {
        var newDate = new Date(date);

        newDate.setUTCDate(newDate.getUTCDate() + d);

        return newDate;
    },

    padTwo : function(n) {
        return padTwo(n);
    },

    humanDuration: function(d) {
         if(!d || d <= 0)
             return '';

         var parts = [],
             minutes = Math.ceil(d / 60),
             hours = 0,
             days = 0,
             lang = BEM.blocks['i-global'].param('lang');

         if(minutes >= 60) {
             hours = Math.floor(minutes / 60);
             minutes = minutes % 60;
         }

         if(hours >= 24) {
             days = Math.floor(hours / 24);
             hours = hours % 24;
         }

         // если есть дни, то минуты округляем до часов
         if(days && minutes) {
             hours += 1;
             minutes = 0;

             if(hours == 24) {
                 days += 1;
                 hours = 0;
             }
         }

         if(days)
             parts.push(this.toNbsp(BEM.I18N('i-time', 'duration-days-short', { 'days': days })));

         if(hours)
             parts.push(this.toNbsp(BEM.I18N('i-time', 'duration-hours-short', { 'hours': hours })));

         if(minutes)
             parts.push(this.toNbsp(BEM.I18N('i-time', 'duration-minutes-short', { 'minutes': minutes })));

         return parts.join(' ');

     },

     toNbsp: function(value) {
         return value.replace(' ', '&nbsp;')
     }

 });

})();
