#!/bin/bash

set -e

# Проверим, нет-ли его уже в репозитории
function is_available {
    sudo apt-get update > /dev/null
    apt-cache show $package-$pkg_version | grep-dctrl -FVersion -X "$pkg_version" -sVersion
}

package=$(grep-dctrl '' -n -sSource debian/control.in)
pkg_version=$(< debian/markup-version)

sed "s/@@PKG_VERSION@@/$pkg_version/" debian/control.in > debian/control

if is_available; then
    echo Пакет уже в репозитории, пропускаем сборку и аплоад
    exit
fi

[ -f "debian/changelog" ] && rm debian/changelog

dch --create --package $package --newversion $pkg_version \
    --distribution unstable --force-distribution \
    "Build $pkg_version" 2> /dev/null

dpkg-buildpackage -b

dupload --to verstka ../${package}_${pkg_version}_amd64.changes

debian/deploy.sh
