#!/usr/bin/env python2
# -*- coding: utf-8 -*-

import os
import shutil
import sys
import subprocess

ENV = {'GIT_DIR': '.git'} # нужно запускать команды только в корневых директориях репозиториев


def ls_files(repo):
    stdout = subprocess.check_output(['git', 'ls-files', '--exclude-standard'], cwd=repo, env=ENV)

    return stdout.splitlines()


def submodule_status(repo):
    stdout = subprocess.check_output(['git', 'submodule', 'status'], cwd=repo, env=ENV)

    submodules = stdout.splitlines()

    for submodule in submodules:
        prefix = submodule[0]

        assert prefix == ' '

        sha, path, sha_desc = submodule[1:].split()

        yield path


def copyrepo(repo, dest):
    files = ls_files(repo)

    for path in submodule_status(repo):
        for f in ls_files(os.path.join(repo, path)):
            files.append(os.path.join(path, f))

    print "Copying files from repo %s to %s... " % (repo, dest),

    for i, path in enumerate(files):
        realpath = os.path.join(repo, path)
        destpath = os.path.join(dest, path)
        destdir = os.path.dirname(destpath)

        if not os.path.isdir(destdir):
            os.makedirs(destdir)

        if os.path.islink(realpath):
            os.symlink(os.readlink(realpath), destpath)
        elif os.path.isfile(realpath):
            shutil.copyfile(realpath, destpath)
            shutil.copymode(realpath, destpath)
        else:
            raise Exception('Неизвестный тип файла')

        msg = '\033[s%d%%\033[u' % ((i + 1) * 100 / len(files))

        sys.stdout.write(msg)

    print

if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser()

    parser.add_argument('repo')
    parser.add_argument('dest')

    args = parser.parse_args()

    copyrepo(args.repo, args.dest)
