#!/bin/bash

set -e

. debian/vars.sh

pkg_version=$(dpkg-parsechangelog | awk '/^Version:/ { print $2 }')
asset_path=rasp/$pkg_version

dest=debian/$1
main=/usr/local/www/static.yandex.net/$asset_path
maindest=$dest$main
built=debian/markup-built

mkdir -p $maindest

cp -RT $built/blocks-desktop $maindest/blocks-desktop
cp -RT $built/i $maindest/i

find $maindest/blocks-desktop -depth -regextype posix-extended \
    \( -regex ".*\.(gif|png|jpe?g|sfw|ico|svg)" -o \( -type d -a \! -empty \) \) \
    -o -delete

mkdir -p $maindest/pages-desktop/common/

cp $built/pages-desktop/common/_* $maindest/pages-desktop/common/

for page in $STANDALONE_PAGES; do
    pagedir=$built/pages-desktop/$page

    mkdir -p $maindest/$pagedir

    cp $pagedir/_$page.{css,ie*.css} $maindest/$pagedir/
done

for pubjs in $built/pages-desktop/*/_*.pub.js; do
    install -D $pubjs $maindest/${pubjs#$built/}
done

mkdir -p $maindest/pages-desktop/next-trains-settings

cp $built/pages-desktop/next-trains-settings/* $maindest/pages-desktop/next-trains-settings/
