# -*- coding: utf-8 -*-

import re
from datetime import timedelta
from django.utils.http import urlencode
from django.http import HttpResponseRedirect

from common.models.currency import Price, Currency

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.templates.order.error import bad_link_error


ORDER_URL = 'https://allticketsfor.me/raileurope.html'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    too_late = (can_buy_context['segment'].departure - can_buy_context['now']) < timedelta(days=1)
    too_early = (can_buy_context['segment'].departure - can_buy_context['now']) > timedelta(days=90)

    if too_late or too_early:
        return False

    return True


city_code_re = re.compile('^c(\d+)-t\d+$')
def order(request, order_data):
    segment = order_data['segment']
    data = order_data['choice']

    station_from_code_match = city_code_re.match(data['station_from_code'])
    station_to_code_match = city_code_re.match(data['station_to_code'])

    if not station_from_code_match or not station_to_code_match:
        return bad_link_error(request)

    params = {
        'arr': station_to_code_match.group(1),
        'dep': station_from_code_match.group(1),
        'ddep': segment.departure.strftime('%Y-%m-%d'),
        'tdep': segment.departure.strftime('%H-%M'),
        'autoSearch': 'true',
        'clientId': '40813',
        'back': 'no',
    }

    url = ORDER_URL + '?' + urlencode(params)

    return HttpResponseRedirect(url)


def get_price_data(segment):
    order_data = {
        'supplier': 'allticketsfor-me',
        'partner': 'allticketsfor-me',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'allticketsfor_me_click',
    }


def calc_final_price(price, currency_rates):
    if Currency.BASE_CURRENCY != 'RUR':
        return price

    if price.currency != 'EUR':
        return price

    price.base_value = None

    price += Price(2, 'EUR')

    if not currency_rates:
        return price

    rate = currency_rates.get('EUR')

    if rate is None:
        return price

    price.value = price.value * rate
    price.currency = 'RUR'

    price += Price(350, 'RUR')

    price.rebase(currency_rates)

    return price
