# -*- coding: utf-8 -*-

from django.http import HttpResponseRedirect
from django.utils.http import urlencode


def can_buy_from(request, supplier_code, can_buy_context):
    order_data = can_buy_context['order_data']
    if not can_buy_context['order_data']:
        return False

    if 'etraffic_races' not in order_data:
        return False

    segment_departure = can_buy_context['segment'].departure

    dispatch_date = segment_departure.strftime('%Y-%m-%d %H:%M:%S')
    race = order_data['etraffic_races'].get(dispatch_date)

    return race


def get_price_data(segment):
    data = segment.display_info.tariffs_info.order_data

    dispatch_date = segment.departure.strftime('%Y-%m-%d %H:%M:%S')

    race = data['etraffic_races'].get(dispatch_date)

    if not race:
        return {}

    order_data = {
        'supplier': 'e-traffic',
        'partner': 'e-traffics',  # Для счётчика покупок

        'depot': data['depot'],
        'race': race,
        'station': data['to_code'],
        'date': dispatch_date,
    }

    return {
        'order_data': order_data,
        'click': 'etraffic_click',
    }


def order(request, order_data):
    choice = order_data['choice']
    url = 'http://e-traffic.ru/purchase?' + urlencode({
        'depot': choice['depot'],
        'race': choice['race'],
        'station': choice['station'],
        'date': choice['date'],
    })

    return HttpResponseRedirect(url)
