# -*- coding: utf-8 -*-

from datetime import timedelta

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id


KAMILKOC_URL = 'https://www.kamilkoc.com.tr/biletsatinal?'


def can_buy_from(request, supplier_code, can_buy_context):
    order_data = can_buy_context['order_data']
    if not order_data:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    try:
        key = segment_departure.strftime('%Y-%m-%d %H:%M:%S')
        sale_close_minutes = int(order_data['voyages'][key]['sale_close_minutes'])

        return now + timedelta(minutes=sale_close_minutes) < segment_departure

    except (KeyError, ValueError):
        return False


def get_price_data(segment):
    data = segment.display_info.tariffs_info.order_data

    key = segment.departure.strftime('%Y-%m-%d %H:%M:%S')

    voyage_data = data['voyages'][key]

    order_data = {
        'supplier': 'kamilkoc',
        'partner': 'kamilkoc',  # Для счётчика покупок
        'show_id': show_id(0),

        'departure_id': data['departure_id'],
        'arrival_id': data['arrival_id'],
        'voyage_id': voyage_data['voyage_id'],
        'sale_close_minutes': voyage_data['sale_close_minutes'],
    }

    return {
        'order_data': order_data,
        'click': 'kamilkoc_click',
    }


def order(request, order_data):
    data = order_data['choice']

    segment = order_data['segment']

    params = {
        'd': data['departure_id'],
        'a': data['arrival_id'],
        'da': segment.departure.strftime('%Y/%m/%d'),
        'vid': data['voyage_id'],
    }

    url = KAMILKOC_URL + urlencode(params)

    return HttpResponseRedirect(url)
