# -*- coding: utf-8 -*-

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id


PAMUKKALE_URL = 'https://pamukkale.com.tr/Bilet.php?'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    return True


def get_price_data(segment):
    order_data = {
        'supplier': 'pamukkale',
        'partner': 'pamukkale',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'pamukkale_click',
    }


def order(request, order_data):
    segment = order_data['segment']

    data = order_data['choice']

    params = {
        'Kalkis': data['station_from_code'],
        'Varis': data['station_to_code'],
        'Tarih': segment.departure.strftime('%d-%m-%Y'),
    }

    url = PAMUKKALE_URL + urlencode(params)

    return HttpResponseRedirect(url)
