# -*- coding: utf-8 -*-

from datetime import timedelta
from django.http import HttpResponseRedirect

from travel.rasp.morda.morda.order.utils import show_id


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    return now + timedelta(minutes=15) < segment_departure < now + timedelta(days=30)


def get_price_data(segment):
    order_data = {
        'supplier': 'Pavlodar-AV',
        'partner': 'Pavlodar-AV',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'pavlodar_click',
    }


def order(request, order_data):
    data = order_data['choice']

    segment = order_data['segment']

    departure = segment.departure

    departure_date = departure.strftime('%Y-%m-%d')
    departure_time = departure.strftime('%H-%M')

    url = u'http://avpv.kz/yandex/{station_from_code}/{station_to_code}/{departure_date}/{departure_time}/'\
        .format(station_from_code=data['station_from_code'],
                station_to_code=data['station_to_code'],
                departure_date=departure_date, departure_time=departure_time)

    return HttpResponseRedirect(url)
