# -*- coding: utf-8 -*-

from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id


def can_buy_from(request, supplier_code, can_buy_context):
    order_data = can_buy_context['order_data']
    if not order_data:
        return False

    return 'station_from_udm_code' in order_data and 'station_to_udm_code' in order_data


def get_price_data(segment):
    """
    Урл перехода формируется так:
    http://avokzal.udm.ru/booking/?fromName=000000429&toName=000000069&when=25.04.2012&time=15:55
    в полях fromName и toName - коды станций из поискового контекста в системе кодирования удмуртов
    в поле when - дата из поискового контекста
    в поле time - время отправления данного рейса со станции отправления из поискового контекста
    """

    data = segment.display_info.tariffs_info.order_data

    params = {
        'fromName': data['station_from_udm_code'],
        'toName': data['station_to_udm_code'],
        'when': segment.departure.strftime('%d.%m.%Y'),
        'time': segment.departure.strftime('%H:%M'),
    }

    redirect_url = 'http://avokzal.udm.ru/booking/?' + urlencode(params)

    order_data = {
        'supplier': 'udmbus',
        'partner': 'udmbus',  # Для счётчика покупок
        'url': redirect_url,
        'show_id': show_id(0)
    }

    return {
        'order_data': order_data,
        'click': 'udmbus_click',
    }
