# -*- coding: utf-8 -*-

from datetime import timedelta

from django.http import HttpResponseRedirect
from django.utils.http import urlencode

from travel.rasp.morda.morda.order.utils import show_id
from travel.rasp.morda.morda.order.views.partners.utils import get_number_of_days_to_departure


UNITIKI_URL = 'https://unitiki.com/yandex/result?'


def can_buy_from(request, supplier_code, can_buy_context):
    if not can_buy_context['order_data']:
        return False

    segment_departure = can_buy_context['segment'].departure
    now = can_buy_context['now']

    too_late = get_number_of_days_to_departure(now, segment_departure) > 90
    too_early = segment_departure < now + timedelta(minutes=5)

    return not too_early and not too_late


def get_price_data(segment):
    order_data = {
        'supplier': 'unitiki',
        'partner': 'unitiki',  # Для счётчика покупок
        'show_id': show_id(0),
    }

    order_data.update(segment.display_info.tariffs_info.order_data)

    return {
        'order_data': order_data,
        'click': 'unitiki_click',
    }


def order(request, order_data):
    segment = order_data['segment']
    data = order_data['choice']

    params = {
        'station_to_code': data['station_to_code'],
        'station_from_code': data['station_from_code'],
        'date': segment.departure.strftime('%Y-%m-%d'),
        'time': segment.departure.strftime('%H:%M'),
    }

    url = UNITIKI_URL + urlencode(params)

    return HttpResponseRedirect(url)

