# -*- coding: utf-8 -*-

from datetime import datetime

from common.models.tariffs import CLS_NAMES
from travel.rasp.library.python.common23.date import environment
from common.xgettext.i18n import gettext, xgettext, dynamic_gettext

from travel.rasp.morda.morda.utils.locations import search_url


class Error(object):
    def __init__(self, message):
        self._message = message

    def get_message(self, data):
        if self._message == 'too_late_or_early':
            if data['segment'].departure >= environment.now_aware():
                return gettext(u'К сожалению, на данный поезд пока ещё нельзя купить билет.')

            else:
                return gettext(u'К сожалению, на данный поезд уже нельзя купить билет. Попробуйте поискать поезд, отправляющийся позднее.')

        elif self._message == 'no_seats':
            url = search_url(
                data['point_from'] or data['station_from'],
                data['point_to'] or data['station_to'],
                when=data['date'],
            )

            mess = xgettext(u'К сожалению, на данный поезд уже нельзя купить билет. Попробуйте <link>выбрать другой поезд</link>',
                            link=lambda content: {
                                'block': 'b-link',
                                'url': url,
                                'content': content
                            })

            return mess


class Train(object):
    def __init__(self, number):
        self.number = number
        self.classes = []


class BaseKlass(object):
    def __init__(self, code):
        self.code = code
        self.free = 0
        self.free_by_type = {}
        self.coaches = []
        self.order_data = {}
        self.order_rules_data = {}
        self.tariff = None
        self.from_ = False
        self.service_class_code = None
        self.owner = None
        self.r = []
        self.mf = False
        self.child_tariff = False
        self.wn = False

    @property
    def name(self):
        return dynamic_gettext(CLS_NAMES[self.code])

    def get_services(self):
        return []

    def add(self, coach):
        for type_, n in coach.free_by_type.items():
            self.free_by_type[type_] = self.free_by_type.get(type_, 0) + n

        self.free += coach.free

        self.coaches.append(coach)


class Coach(object):
    @classmethod
    def empty_seats(cls):
        return {
            'free': set(),
            'sex': set(),
            'male': set(),
            'female': set(),
            'mixed': set(),
            'all': set(),
        }

    def __init__(self):
        self.free = 0
        self.free_by_type = {}
        self.seats = self.empty_seats()
        self.seats_params = None
        self.schema = None
        self.two_storey = False
        self.order_data = {}
