# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import url

from travel.rasp.morda.morda.redirects.views import (
    redirect_to, search, station_schedule, change_tablo_sett, ticket_order, ticket, security_scanner_proxy
)

urlpatterns = [
    # url(r'^help$', redirect_to, {'url': '/info/help'}),
    url(r'^partners$', redirect_to, {'url': '/info/partners'}),
    # url(r'^search$', search),
    url(r'^suburban_search', search, {'t': 'suburban'}),
    # url(r'^nearest/suburban', search, {'t': 'next'}),
    # url(r'^transfers', search, {'t': 'transfers'}),
    url(r'^tablo/station/(?P<station_id>\d+)', redirect_to, {'url': '/station/%(station_id)s/'}),
    # url(r'^tablo/station/esr/(?P<esr_code>\d+)', redirect_to, {'url': '/station/esr/%(esr_code)s/'}),
    # url(r'^map_compact', redirect_to, {'url': '/map/air/compact/'}),
    url(r'^map/trains$', redirect_to, {'url': '/map/trains/'}),
    url(r'^map', redirect_to, {'url': '/map/air/'}),
    # url(r'^trains_compact', redirect_to, {'url': '/map/trains/compact/'}),
    # url(r'^trains', redirect_to, {'url': '/map/trains/'}),
    # url(r'^schedule/(departure|arrival)/(train|plane)/(.*?)/(\d+)', station_schedule),
    url(r'^tablo/city/(?P<id>\d+)/', redirect_to, {'url': '/city/%(id)s/'}),
    # url(r'^change_tablo_sett/(region|country)/(\d+)', change_tablo_sett),

    # url(r'^ticket/order/$', ticket_order),

    # url(r'^ticket', ticket),

    # Фейковые урлы для сканера безопасности RASP-5676
    url(r'^ss/typed_search', security_scanner_proxy, {'handler': 'search.main'}),
    url(r'^ss/thread', security_scanner_proxy, {'handler': 'thread.thread'}),
    url(r'^ss/city', security_scanner_proxy, {'handler': 'city.main'}),
    url(r'^ss/gorod', security_scanner_proxy, {'handler': 'city.main'}),
    url(r'^ss/station', security_scanner_proxy, {'handler': 'station.station', 'param': 'station_id'}),
    url(r'^ss/station_esr', security_scanner_proxy, {'handler': 'station.station_esr', 'param': 'esr_code'}),
    url(r'^ss/city_directions', security_scanner_proxy, {'handler': 'city.direction'}),
    url(r'^ss/widget_tablo', security_scanner_proxy, {'handler': 'station.widget_tablo'}),

    # promosearch
    # url(r'^(?:fi/|fin/|finland/)', redirect_to, {'url': 'https://fi.rasp.yandex.ru/'}),

    # url(r'^O14/$', redirect_to, {'url': '/o14/'}),
    # url(r'^014/$', redirect_to, {'url': '/o14/'}),
]
