# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.urlresolvers import get_callable
from django.http import HttpResponseRedirect, HttpResponsePermanentRedirect, Http404
from django.utils.http import urlencode

from common.utils.locations import langify, composeurl
from common.views.currency import fetch_currency_info
from common.models.geo import Country, Region
from common.xgettext.i18n import gettext


TICKET_CLID = 2289669

def search(request, t=None):
    params = request.GET

    new_params = {}

    if 'cityFrom' in params:
        new_params['fromName'] = params['cityFrom']

    if 'cityTo' in params:
        new_params['toName'] = params['cityTo']

    if 'cityFromId' in params:
        new_params['fromId'] = 'c' + params['cityFromId']
    elif 'stationFromId' in params:
        new_params['fromId'] = 's' + params['stationFromId']

    if 'cityToId' in params:
        new_params['toId'] = 'c' + params['cityToId']
    elif 'stationToId' in params:
        new_params['toId'] = 's' + params['stationToId']

    if 'dateForward' in params:
        new_params['when'] = params['dateForward']

    if params.get('all_days_search'):
        new_params['when'] = gettext(u'на все дни')

    if t == 'transfers':
        new_params['transfers'] = 't'

    if 'backward' in params:
        new_params['backward'] = '1'

    if t == 'suburban':
        path = '/search/suburban/'

        if 'widgetSearch' in params:
            path = '/search/suburban/next/'
    elif t == 'next':
        path = '/search/suburban/next/'
    else:
        path = '/search/'

        if params.get('typeFilter') in ['train', 'plane', 'bus', 'suburban']:
            path = '/search/%s/' % params['typeFilter']

    return HttpResponsePermanentRedirect(langify(path + '?' + urlencode(new_params)))


def redirect_to(request, url, **params):
    host_path = (url % params).encode('utf-8')
    query = request.META['QUERY_STRING']

    redirect_url = host_path

    if query:
        redirect_url += '?' + query

    return HttpResponsePermanentRedirect(redirect_url)


def station_schedule(request, event, t_type_code, uid, station_id):
    params = {}

    if event == 'departure':
        params['station_from'] = station_id
    else:
        params['station_to'] = station_id

    return HttpResponsePermanentRedirect(composeurl('thread', args=[uid], params=params))


def get_area(area_type, area_id):
    if area_type == 'country':
        try:
            return Country.objects.get(id=area_id)
        except Country.DoesNotExist:
            return None
    elif area_type == 'region':
        try:
            return Region.hidden_manager.get(id=area_id)
        except Region.DoesNotExist:
            return None

    return None


def change_tablo_sett(request, area_type, area_id):
    area = get_area(area_type, area_id)

    if not area:
        raise Http404()

    capital = area.get_capital()

    if not capital:
        raise Http404()

    return HttpResponsePermanentRedirect(composeurl('city', args=[capital.id]))


def ticket_order(request):
    COUNTER = 'https://clck.yandex.ru/redir/dtype=stred/pid=168/cid=70831/*'

    params = request.GET.copy()

    info = fetch_currency_info(request)

    params['currency'] = info.selected
    params['clid'] = TICKET_CLID
    if 'lang' not in params:
        params['lang'] = request.LANGUAGE_CODE

    url = COUNTER + 'https:' + request.ticket_url + 'v2/order/?' + params.urlencode()

    return HttpResponseRedirect(url)


def ticket(request):
    return HttpResponsePermanentRedirect('https://%s/' % settings.TICKET_HOST)


def security_scanner_proxy(request, handler, param=None):
    u"Вьюха, транслирующая специальные урлы сканера безопасности в нормальные вьюхи"
    view = get_callable('www.views.' + handler)
    if param:
        return view(request, **{param:request.GET['id']})
    else:
        return view(request, request.GET['id'])
