# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.disclaimers import StaticText
from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xgettext

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base


class DirectionMapTemplate(Base):
    page = 'scheme'

    def content(self):
        city_url = composeurl('city', args=[self.context.city.id])
        city_link = {
            'block': 'b-link',
            'url': city_url,
            'mods': {'theme': 'black'},
            'content': self.context.city.L_title()
        }

        return {
            'block': 'l-page',
            'mods': {'layout': '72_20', 'row': 'multiple'},
            'content': [
                {
                    'elem': 'row',
                    'content': [
                        {'elem': 'gap'},
                        {
                            'elem': 'left',
                            'mods': {'type': '72-20'},
                            'content': [
                                {
                                    'block': 'b-page-title',
                                    'content': {
                                        'elem': 'title',
                                        'content': xgettext(
                                            # Москва. Расписание электричек — Белорусское направление
                                            "<city-link/>. Расписание электричек — <direction-title/>",
                                            city_link=city_link,
                                            direction_title=self.context.direction.L_full_title()
                                        )
                                    }
                                },
                                {
                                    'block': 'b-static-text',
                                    'content': [
                                        {
                                            'tag': 'p',
                                            'content': StaticText.get_text_by_code('direction_help')
                                        }
                                    ]
                                }
                            ]
                        },
                        {'elem': 'gap-right'},
                        {
                            'elem': 'right',
                            'content': {
                                'block': 'b-menu',
                                'mods': {'layout': 'horiz-complex', 'preset': 'media-links'},
                                'content': self.ya_share()
                            }
                        },
                        {'elem': 'gap'}
                    ]
                },
                {
                    'elem': 'row',
                    'content': [
                        {'elem': 'gap'},
                        {
                            'elem': 'left',
                            'mods': {'type': '72-20'},
                            'content': [
                                {
                                    'block': 'l-scheme',
                                    'js': True,
                                    'content': [
                                        {
                                            'elem': 'tabs',
                                            'content': [
                                                {
                                                    'elem': 'tab',
                                                    'elemMods': {'state': 'current'},
                                                    'content': {
                                                        'block': 'b-link',
                                                        'js': True,
                                                        'mods': {'pseudo': 'yes', 'theme': 'black', 'type': 'map'},
                                                        'url': '#',
                                                        'content': gettext('Схема')
                                                    }
                                                } if self.context.schema else None,
                                                {
                                                    'elem': 'tab',
                                                    'content': {
                                                        'block': 'b-link',
                                                        'js': True,
                                                        'mods': {'pseudo': 'yes', 'theme': 'black', 'type': 'alpha'},
                                                        'url': '#',
                                                        'content': gettext('Алфавитный&#0160;указатель')
                                                    }
                                                }
                                            ]
                                        },
                                        self.scheme() if self.context.schema else None,
                                        self.scheme_alpha(),
                                    ]
                                }
                            ]
                        },
                        {'elem': 'gap-right'},
                        {
                            'elem': 'right',
                            'content': [
                                self.directions_list(),
                                self.teaser('ahtung'),
                                self.b_yadirect()
                            ]
                        },
                        {'elem': 'gap'}
                    ]
                }
            ]
        }

    def scheme_alpha(self):
        columns = []
        for column in self.context.stations_by_column:
            col = []

            for letter, stations in column:
                col.append({
                    'elem': 'title',
                    'content': letter
                })

                for station in stations:
                    col.append({
                        'elem': 'item',
                        'content': {
                            'block': 'b-link',
                            'url': composeurl('station', args=[station.id],
                                              params={'type': 'suburban', 'span': 'schedule', 'direction': self.context.direction.code}),
                            'content': (
                                xgettext('Аэропорт <airport-title/>', airport_title=station.L_title())
                                if station.t_type.code == 'plane' else
                                station.L_title()
                            )
                        }
                    })

            columns += [
                {'elem': 'gap'},
                {
                    'elem': 'column',
                    'content': [
                        {
                            'block': 'b-scheme-alpha',
                            'content': col
                        }
                    ]
                }
            ]

        return {
            'elem': 'pane',
            'elemMods': { 'type': 'alpha' } if self.context.schema else { 'type': 'alpha', 'show': 'yes' },
            'content': {
                'block': 'l-scheme-alpha',
                'content': columns
            }
        }

    def _zone_type(self, i):
        if i % 2:
            return '1'
        return '2'

    def scheme(self):
        zones = []

        i = 1
        for num, rows in self.context.schema:
            mods = {'type': self._zone_type(i)}

            if i == 1:
                mods['position'] = 'first'

            if num != 'Z':
                if num == 'X':
                    text = gettext('покилометровый тариф')
                else:
                    text = xgettext('<num/> &lt;span&gt;зона&lt;/span&gt;', num=num)

                num_elem = {
                    'elem': 'num',
                    'content': {
                        'elem': 'text',
                        'content': text
                    }
                }
            else:
                num_elem = None

            zone_elems = []
            for row in rows:
                items = []

                for item, href, label, metro, busstations in row:
                    out = item and item.endswith('_f')
                    item_r = item in ('rl_s', 'brl_s', 'trl_s', 'trbl_s', 'trb_s',
                                      'rl_s1', 'brl_s1', 'trl_s1', 'trbl_s1', 'trb_s1',
                                      'rl_m1', 'brl_m1', 'trl_m1', 'trbl_m1', 'trb_m1',
                                      'rl_m', 'brl_m', 'trl_m', 'trbl_m', 'trb_m',)

                    item_elem = {'elem': 'item'}
                    if item_r:
                        item_elem['mods'] = {'type': 'right'}

                    if item == 'r_f':
                        item_elem['mods'] = {'type': 'out-right'}

                    if item == 'l_f':
                        item_elem['mods'] = {'type': 'out-left'}

                    if not item:
                        items.append(item_elem)
                        continue

                    if label:
                        if href:
                            station_label = {
                                'block': 'b-link',
                                'url': href,
                                'content': label
                            }
                        else:
                            station_label = label
                    else:
                        station_label = None

                    if metro:
                        metro_elem = {
                            'elem': 'metro',
                            'content': {
                                'block': 'b-dropdowna',
                                'mods': {'type': 'hint'},
                                'content': [
                                    {
                                        'elem': 'switcher',
                                        'elemMods': {'type': 'hint'},
                                        'content': [{
                                            'block': 'b-icon',
                                            'attrs': {'style': 'cursor: default'},
                                            'mods': {'type': 'hint', 'is-bem': 'yes'},
                                        },
                                        {
                                        'block': 'b-popupa',
                                        'js': True,
                                        'mods': {'theme': 'feffd6', 'direciton': 'up'},
                                        'content': [
                                            {'elem': 'tail'},
                                            {
                                                'elem': 'content',
                                                'content': metro
                                            }
                                        ]
                                    }]
                                    },

                                ]
                            }
                        }
                    else:
                        metro_elem = None

                    if busstations:
                        if len(busstations) == 1:
                            title, bhref = busstations[0]
                            bus_elem_content = {
                                'block': 'b-link',
                                'url': bhref,
                                'content': {'block': 'b-icon'}
                            }
                        else:
                            bus_elem_content = {
                                'block': 'b-dropdowna',
                                'content': [
                                    {
                                        'elem': 'switcher',
                                        'content': {
                                            'block': 'b-link',
                                            'mods': {'pseudo': 'yes', 'mod': 'icon'},
                                            'content': {'block': 'b-icon'}
                                        }
                                    },
                                    {
                                        'block': 'b-popupa',
                                        'mods': {'theme': 'ffffff', 'direction': 'up'},
                                        'content': [
                                            {'elem': 'tail'},
                                            {
                                                'elem': 'content',
                                                'content': {
                                                    'block': 'b-menu',
                                                    'mods': {'layout': 'vert'},
                                                    'mix': [{'block': 'b-dropdowna', 'elem': 'menu'}],
                                                    'content': [{
                                                        'elem': 'item',
                                                        'content': {
                                                            'block': 'b-link',
                                                            'content': title,
                                                            'url': bhref
                                                        }
                                                    } for title, bhref in busstations]
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }

                        bus_elem = {
                            'elem': 'bus',
                            'content': bus_elem_content
                        }
                    else:
                        bus_elem = None

                    station_item = {
                        'elem': 'direction' if out else 'station',
                        'content': [
                            station_label,
                            metro_elem,
                            bus_elem
                        ]
                    }

                    icon = {
                        'block': 'b-icon',
                        'url': self.static_url('blocks-desktop/b-scheme/i/%s.png' % item)
                    }

                    if href:
                        icon = {
                            'block': 'b-link',
                            'url': href,
                            'content': icon
                        }

                    item_elem['content'] = [station_item, icon]

                    items.append(item_elem)

                zone_elems.append({
                    'elem': 'row',
                    'content': items
                })

            zone = {
                'elem': 'zone',
                'elemMods': mods,
                'content': [
                    num_elem
                ] + zone_elems
            }
            zones.append(zone)
            i += 1

        return {
            'elem': 'pane',
            'elemMods': {'type': 'map', 'show': 'yes'},
            'content': {
                'block': 'b-scheme',
                'js': True,
                'content': zones
            }
        }

    def directions_list(self):
        all_directions = list(self.context.main_directions) + list(self.context.directions)
        directions_list = []

        for d in all_directions:
            item = {
                'elem': 'item'
            }

            if d == self.context.direction:
                item['content'] = d.L_title()
                item['mods'] = {'state': 'current'}
            else:
                item['content'] = {
                    'block': 'b-link',
                    'url': composeurl('city_direction', args=[self.context.city.id], params={'direction': d.code}),
                    'content': d.L_title()
                }

            directions_list.append(item)

        return {
            'block': 'b-small-menu',
            'mods': {'theme': 'scheme'},
            'content': directions_list
        }
