# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext

# Шаблоны
from travel.rasp.morda.morda.templates.base import Base


class ErrorTemplate(Base):
    page = 'search'

    def __init__(self, request, view_context, messages=[], title=None):
        super(ErrorTemplate, self).__init__(request, view_context)

        if title:
            self.context['page_title'] = title

        if messages:
            self.context['search_errors'] = messages

    def page_attrs(self):
        return {
            'onload': self.metrika_reach_goal("search_error_page_load")
        }

    def page_title(self):
        return self.context.page_title or gettext('Ошибка')

    def content(self):
        return False
