# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xgettext

from travel.rasp.morda.morda.templates.maps.base import Template as Base


class Template(Base):
    def __init__(self, *args, **kwargs):
        super(Template, self).__init__(*args, **kwargs)
        self.context['title'] = gettext('Самолётики')

    def content(self):
        return {
            'block': 'l-page',
            'mods': { 'layout': '16-80' },
            'content': [
                { 'elem': 'gap' },
                {
                    'elem': 'left',
                    'content': {
                        'elem': 'left-i',
                        'content': [
                            {
                                'block': 'b-maps-air-desc',
                                'cls': 'i-hidden',
                            },
                            {
                                'block': 'b-maps-search',
                                'mods': { 'type': 'airplanes' },
                                'js': { 'center': self.context.map.center,
                                        'zoom': self.context.map.zoom },
                                'attrs': { 'action': '#', 'method': 'get' },
                                'content': [
                                    {
                                        'block': 'b-form-input',
                                        'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'number' },
                                        'name': 'number',
                                        'attrs': { 'id': 'id2482224' },
                                        'js': {
                                            'dataprovider': { 'url': '/suggests/flights_in_air/number/' },
                                            'debounceDelay': 100,
                                            'popupMods': { 'minwidth': 'small' }
                                        },
                                        'content': [
                                            {
                                                'elem': 'label',
                                                'content': {
                                                    'tag': 'strong',
                                                    'content': gettext('Искать самолётики:')
                                                },
                                            },
                                            { 'elem': 'hint', 'content': gettext('введите номер рейса') },
                                            { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                                        ]
                                    },
                                    {
                                        'elem': 'line',
                                        'content': {
                                            'block': 'b-form-input',
                                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'company' },
                                            'name': 'company',
                                            'attrs': { 'id': 'id2482261' },
                                            'js': {
                                                'dataprovider': { 'url': '/suggests/flights_in_air/company/' },
                                                'debounceDelay': 100,
                                                'popupMods': { 'minwidth': 'small' }
                                            },
                                            'content': [
                                                { 'elem': 'label', 'content': gettext('или') },
                                                { 'elem': 'hint', 'content': gettext('выберите авиакомпанию') },
                                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                                            ]
                                        }
                                    },
                                    {
                                        'elem': 'line',
                                        'content': {
                                            'block': 'b-form-input',
                                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'airport' },
                                            'name': 'airport',
                                            'attrs': { 'id': 'id2482297' },
                                            'js': {
                                                'dataprovider': {
                                                    'url': '/suggests/flights_in_air/airport/',
                                                },
                                                'debounceDelay': 100,
                                                'popupMods': { 'minwidth': 'small' }
                                            },
                                            'content': [
                                                { 'elem': 'label', 'content': gettext('или') },
                                                { 'elem': 'hint', 'content': gettext('выберите аэропорт') },
                                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                                            ]
                                        }
                                    },
                                    {
                                        'elem': 'line',
                                        'content': {
                                            'block': 'b-form-input',
                                            'mods': { 'size': 'm', 'theme': 'grey', 'has-clear': 'yes', 'autocomplete': 'yes', 'mod': 'city' },
                                            'name': 'city',
                                            'attrs': { 'id': 'id2482333' },
                                            'js': {
                                                'dataprovider': {
                                                    'url': '/suggests/flights_in_air/city/',
                                                },
                                                'debounceDelay': 100,
                                                'popupMods': { 'minwidth': 'small' }
                                            },
                                            'content': [
                                                { 'elem': 'label', 'content': gettext('или') },
                                                { 'elem': 'hint', 'content': gettext('выберите город') },
                                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                                            ]
                                        }
                                    },
                                    {
                                        'elem': 'button',
                                        'content': {
                                            'block': 'b-form-button',
                                            'mods': { 'size': 'm', 'theme': 'grey-m' },
                                            'type': 'submit',
                                            'content': gettext('Найти самолётики')
                                        }
                                    }
                                ]
                            },
                            {
                                'block': 'b-static-text',
                                'content': {
                                    'tag': 'p',
                                    'content': gettext('По вашему запросу самолетики не&nbsp;найдены. Попробуйте изменить параметры поиска.'),
                                },
                                'mix': [{ 'block': 'b-page', 'elem': 'not-found' }, { 'block': 'i-hidden' }],
                            },
                            self.b_yadirect()
                        ]
                    }
                },
                {
                    'elem': 'right',
                    'content': [
                        self.b_page_title(),
                        {
                            'block': 'b-static-text',
                            'content': {
                                'tag': 'p',
                                'content': gettext('Местоположение самолётов рассчитано на основе расписания рейсов и не отражает их реального положения. Маршруты могут оперативно меняться.')
                            },
                            'attrs': { 'style': 'color: red' }
                        },
                        self.tabbed_wrapper([
                            {
                                'elem': 'map',
                                'content': {
                                    'block': 'b-map',
                                    'mods': {'type': 'airplanes'},
                                    'js': True
                                }
                            },
                            {
                                'block': 'b-maps-copyright',
                                'content': gettext('Местоположение самолётов рассчитано на основе расписания рейсов.'),
                                'attrs': {'style': 'color: red'}
                            },
                            {
                                'block': 'b-static-text',
                                'content': {
                                    'elem': 'text',
                                    'tag': 'p',
                                    'content': self.get_partner_info()
                                }
                            }
                        ]),
                    ]
                },
                { 'elem': 'gap' }
            ]
        }

    @staticmethod
    def get_partner_info():
        lang = get_language()

        kwargs = {
            'b_link': lambda content, url: {
                    'block': 'b-link',
                    'attrs': { 'target': '_blank' },
                    'url': {
                        'agent': 'http://agent.ru/',
                        'OAG': 'http://www.oag.com/Global',
                        'other-partners': composeurl('partners')
                    }[url],
                    'content': content
            }
        }

        if lang == 'tr':
            return xgettext(u'Данные предоставлены <b-link url="OAG">OAG</b-link> и другими <b-link url="other-partners">партнерами сервиса</b-link>.', **kwargs)

        else:
            return xgettext(u'Данные предоставлены <b-link url="agent">Агент.ру</b-link> и другими <b-link url="other-partners">партнерами сервиса</b-link>.', **kwargs)
