# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.xgettext.i18n import dynamic_gettext, gettext, mark_gettext

from travel.rasp.morda.morda.templates.base import Base


class Template(Base):
    TABS = [
        ('/map/air/', mark_gettext('Самолётики')),
        ('/map/trains/', mark_gettext('Паровозики')),
        ('/map/buses/', mark_gettext('Автобусики')),
    ]

    page = 'maps'

    def head_content_extended(self):
        return [
            self.maps_api_js_elem()
        ]

    def b_tabbed__tab(self, url, content):
        if self.context.request.path == url:
            return {
                'elem': 'tab',
                'elemMods': {'state': 'current'},
                'content': content
            }
        else:
            return {
                'elem': 'tab',
                'content': {'block': 'b-link', 'url': url, 'content': content}
            }

    def b_page_title(self):
        return {
            'block': 'b-page-title',
            'content': {
                'elem': 'title',
                'content': gettext('Поезда, самолёты и автобусы на карте')
            }
        }

    def tabbed_wrapper(self, content):
        return {
            'block': 'b-tabbed',
            'content': [
                {
                    'elem': 'tabs',
                    'content': [
                        self.b_tabbed__tab(url, dynamic_gettext(text))
                        for url, text in self.TABS
                    ]
                },
                {
                    'elem': 'panels',
                    'content': [
                        {
                            'elem': 'panel',
                            'elemMods': { 'state': 'current' },
                            'content': content
                        },
                    ]
                }
            ]
        }
