# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.templates.base import Base

class Template(Base):
    page = 'maps-big'

    def __init__(self, *args, **kwargs):
        super(Template, self).__init__(*args, **kwargs)
        self.context['title'] = gettext('Паровозики')

    def page_mods(self):
        return { 'type': 'maps-big' }

    def head_content_extended(self):
        return [
            self.maps_api_js_elem()
        ]

    def content(self):
        return [
            {
                'block': 'b-map',
                'mods': { 'type': 'trains', 'size': 'big' },
                'js': True
            },
            # FIXIT: ПЛОХОЙ КОД: эти кнопки не отображаются и не нужны
            {
                'block': 'b-maps-search',
                'mods': { 'type': 'trains' },
                'cls': 'i-hidden',
                'js': { 'center': self.context.map.center,
                        'zoom': self.context.map.zoom },
                'attrs': { 'action': '#', 'method': 'get' },
                'content': [
                    {
                        'block': 'b-form-input',
                        'mods': {
                            'size': 'm',
                            'theme': 'grey',
                            'has-clear': 'yes',
                            'autocomplete': 'yes',
                            'mod': 'number'
                        },
                        'name': 'number',
                        'attrs': { 'id': 'id2482224' },
                        'js': {
                            'dataprovider': {
                                'url': '/suggests/trains_on_map/number/',
                            },
                            'debounceDelay': 100,
                            'popupMods': { 'minwidth': 'small' }
                        },
                        'content': [
                            { 'elem': 'label', 'content': '<strong>Искать паровозики:</strong>' },
                            { 'elem': 'hint', 'content': gettext('введите номер рейса') },
                            { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                        ]
                    },
                    {
                        'elem': 'line',
                        'content': [
                            { 'elem': 'or', 'content': 'или выберите тип' },
                            {
                                'block': 'b-form-select',
                                'name': 'type',
                                'attrs': { 'id': 'search_type' },
                                'mods': {
                                    'size': 'm',
                                    'theme': 'grey',
                                    'mod': 'type'
                                },
                                'content': [
                                    {
                                        'block': 'b-form-button',
                                        'mods': { 'valign': 'middle', 'size': 'm', 'theme': 'grey-m' },
                                        'type': 'button',
                                        'content': 'раз'
                                    },
                                    {
                                        'elem': 'select',
                                        'content': [
                                            {
                                                'elem': 'option',
                                                'attrs': { 'value': 'all' },
                                                'content': 'все'
                                            },
                                            {
                                                'elem': 'option',
                                                'attrs': { 'value': 'train' },
                                                'content': 'поезда'
                                            },
                                            {
                                                'elem': 'option',
                                                'attrs': { 'value': 'suburban' },
                                                'content': 'электрички'
                                            },
                                            {
                                                'elem': 'option',
                                                'attrs': { 'value': 'express' },
                                                'content': 'экспрессы'
                                            }
                                        ]
                                    }
                                ]
                            },
                        ]
                    },
                    {
                        'elem': 'line',
                        'content': {
                            'block': 'b-form-input',
                            'mods': {
                                'size': 'm',
                                'theme': 'grey',
                                'has-clear': 'yes',
                                'autocomplete': 'yes',
                                'mod': 'station'
                            },
                            'name': 'station',
                            'attrs': { 'id': 'id2482261' },
                            'js': {
                                'dataprovider': {
                                    'url': '/suggests/trains_on_map/station/',
                                    },
                                'debounceDelay': 100,
                                'popupMods': { 'minwidth': 'small' }
                            },
                            'content': [
                                { 'elem': 'label', 'content': 'или' },
                                { 'elem': 'hint', 'content': 'выберите станцию' },
                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                            ]
                        }
                    },
                    {
                        'elem': 'line',
                        'content': {
                            'block': 'b-form-input',
                            'mods': {
                                'size': 'm',
                                'theme': 'grey',
                                'has-clear': 'yes',
                                'autocomplete': 'yes',
                                'mod': 'city'
                            },
                            'name': 'city',
                            'attrs': { 'id': 'id2482297' },
                            'js': {
                                'dataprovider': {
                                    'url': '/suggests/trains_on_map/city/',
                                },
                                'debounceDelay': 100,
                                'popupMods': { 'minwidth': 'small' }
                            },
                            'content': [
                                { 'elem': 'label', 'content': 'или' },
                                { 'elem': 'hint', 'content': 'выберите город' },
                                { 'elem': 'input', 'clear': { 'elem': 'clear' } }
                            ]
                        }
                    },
                    {
                        'elem': 'button',
                        'content': {
                            'block': 'b-form-button',
                            'mods': { 'size': 'm', 'theme': 'grey-m' },
                            'type': 'submit',
                            'content': gettext('Найти паровозики')
                        }
                    }
                ]
            }
        ]

    def page_content(self):
        return [
            self.content(),
            self.b_mooa()
        ]
