# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.templates.maps.base import Template as Base


class Template(Base):
    DATA_PREFIX = '/maps/train/'

    def __init__(self, *args, **kwargs):
        super(Template, self).__init__(*args, **kwargs)

        self.context['title'] = self.get_title()

    def get_title(self):
        return gettext('Паровозики')

    def get_disclaimer(self):
        return gettext('Местоположение поездов рассчитано на основе расписания рейсов.')

    def get_not_found_message(self):
        return gettext('По вашему запросу паровозики не&nbsp;найдены. Попробуйте изменить параметры поиска.')

    def tab_content(self):
        return [
            {
                'elem': 'map',
                'content': {
                    'block': 'b-map',
                    'mods': {'type': 'trains'},
                    'js': {
                        'data-url': self.DATA_PREFIX
                    }
                }
            },
            {
                'block': 'b-maps-copyright',
                'content': self.get_disclaimer()
            },
        ]

    def b_maps_search(self):
        lang = get_language()

        return {
            'block': 'b-maps-search',
            'mods': {'type': 'trains'},
            'js': {'center': self.context.map.center, 'zoom': self.context.map.zoom},
            'attrs': {'action': '#', 'method': 'get'},
            'content': [
                {
                    'block': 'b-form-input',
                    'mods': {
                        'size': 'm',
                        'theme': 'grey',
                        'has-clear': 'yes',
                        'autocomplete': 'yes',
                        'mod': 'number'
                    },
                    'name': 'number',
                    'attrs': {'id': 'id2482224'},
                    'js': {
                        'dataprovider': {
                            'url': '/suggests/livemap/train/number/',
                        },
                        'debounceDelay': 100,
                        'popupMods': {'minwidth': 'small'}
                    },
                    'content': [
                        {
                            'elem': 'label',
                            'content': {
                                'tag': 'strong',
                                'content': gettext('Искать паровозики:')
                            },
                        },
                        {'elem': 'hint', 'content': gettext(u'введите номер рейса')},
                        {'elem': 'input', 'clear': {'elem': 'clear'}}
                    ]
                },
                None if lang == 'tr' else {
                    'elem': 'line',
                    'content': [
                        {'elem': 'or', 'content': gettext('или выберите тип')},
                        {
                            'block': 'b-form-select',
                            'name': 'type',
                            'attrs': {'id': 'search_type'},
                            'mods': {
                                'size': 'm',
                                'theme': 'grey',
                                'mod': 'type'
                            },
                            'content': [
                                {
                                    'block': 'b-form-button',
                                    'mods': {'valign': 'middle', 'size': 'm', 'theme': 'grey-m'},
                                    'type': 'button',
                                    'content': gettext('тип')
                                },
                                {
                                    'elem': 'select',
                                    'content': [
                                        {
                                            'elem': 'option',
                                            'attrs': {'value': 'all'},
                                            'content': gettext('все')
                                        },
                                        {
                                            'elem': 'option',
                                            'attrs': {'value': 'train'},
                                            'content': gettext('поезда')
                                        },
                                        {
                                            'elem': 'option',
                                            'attrs': {'value': 'suburban'},
                                            'content': gettext('электрички')
                                        },
                                        {
                                            'elem': 'option',
                                            'attrs': {'value': 'express'},
                                            'content': gettext('экспрессы')
                                        }
                                    ]
                                }
                            ]
                        },
                    ]
                },
                {
                    'elem': 'line',
                    'content': {
                        'block': 'b-form-input',
                        'mods': {
                            'size': 'm',
                            'theme': 'grey',
                            'has-clear': 'yes',
                            'autocomplete': 'yes',
                            'mod': 'station'
                        },
                        'name': 'station',
                        'attrs': {'id': 'id2482261'},
                        'js': {
                            'dataprovider': {
                                'url': '/suggests/livemap/train/station/',
                            },
                            'debounceDelay': 100,
                            'popupMods': {'minwidth': 'small'}
                        },
                        'content': [
                            {'elem': 'label', 'content': gettext('или')},
                            {'elem': 'hint', 'content': gettext('выберите станцию')},
                            {'elem': 'input', 'clear': {'elem': 'clear'}}
                        ]
                    }
                },
                {
                    'elem': 'line',
                    'content': {
                        'block': 'b-form-input',
                        'mods': {
                            'size': 'm',
                            'theme': 'grey',
                            'has-clear': 'yes',
                            'autocomplete': 'yes',
                            'mod': 'city'
                        },
                        'name': 'city',
                        'attrs': {'id': 'id2482297'},
                        'js': {
                            'dataprovider': {
                                'url': '/suggests/livemap/train/city/',
                            },
                            'debounceDelay': 100,
                            'popupMods': {'minwidth': 'small'}
                        },
                        'content': [
                            {'elem': 'label', 'content': gettext('или')},
                            {'elem': 'hint', 'content': gettext('выберите город')},
                            {'elem': 'input', 'clear': {'elem': 'clear'}}
                        ]
                    }
                },
                {
                    'elem': 'button',
                    'content': {
                        'block': 'b-form-button',
                        'mods': {'size': 'm', 'theme': 'grey-m'},
                        'type': 'submit',
                        'content': gettext('Найти паровозики')
                    }
                }
            ]
        }

    def content(self):
        return {
            'block': 'l-page',
            'mods': { 'layout': '16-80' },
            'content': [
                { 'elem': 'gap' },
                {
                    'elem': 'left',
                    'content': {
                        'elem': 'left-i',
                        'content': [
                            {
                                'block': 'b-maps-air-desc',
                                'cls': 'i-hidden',
                            },
                            self.b_maps_search(),
                            {
                                'block': 'b-static-text',
                                'content': {
                                    'tag': 'p',
                                    'content': self.get_not_found_message(),
                                },
                                'mix': [{ 'block': 'b-page', 'elem': 'not-found' }, { 'block': 'i-hidden' }],
                            },
                            self.b_yadirect()
                        ]
                    }
                },
                {
                    'elem': 'right',
                    'content': [
                        self.b_page_title(),
                        self.tabbed_wrapper(self.tab_content()),
                    ]
                },
                { 'elem': 'gap' }
            ]
        }
