# -*- coding: utf-8 -*-

# Шаблоны
from static import BaseTemplate

class Template(BaseTemplate):

    def __init__(self, request, view_context):
        super(Template, self).__init__(request, view_context)

        self.sorted_types = sorted(self.context.groups.keys())


    def static_content(self):
        return [
            {
                'block': 'b-tabbed-pane',
                'mods': {'preset': 'shadow'},
                'content': [
                    self.tabs(),
                    self.panels()
                ]
            }
        ]

    def panels(self):
        panels = []

        for t_type in self.sorted_types:
            d = self.context.groups[t_type]
            partners = [{
                    'elem': 'item',
                    'title': partner.L_title(),
                    'url': partner.url,
                    'icon': partner.logo.url,
                    'text': partner.L_content()
                } for partner in d['partners']]

            panel = {
                'elem': 'panel',
                'content': {
                    'block': 'b-partners',
                    'content': partners
                }
            }

            if d['current']:
                panel['elemMods'] = {'state': 'current'}

            panels.append(panel)

        return {
            'elem': 'panels',
            'content': panels
        }

    def tabs(self):
        tabs = []

        for t_type in self.sorted_types:
            d = self.context.groups[t_type]
            tab = {
                'elem': 'tab',
                'content': d['title'],
            }
            if d['current']:
                tab['elemMods'] = {'state': 'current'}
            tabs.append(tab)

        return {
            'elem': 'tabs',
            'content': tabs
        }
