# -*- coding: utf-8 -*-

"""Расстановка переносов
"""

import re

CONSONANTS = u'бвгджзклмнпрстфхцчшщ'
VOWELS = u'аеёиоуыэюя'

SYLLABLE = re.compile(u'([бвгджзйклмнпрстфхцчшщ]+[аеёиоуыэюя][бвгджзйклмнпрстфхцчшщ]*|[аеёиоуыэюя][бвгджзйклмнпрстфхцчшщ]+)', re.U | re.I)


def _hyphenize(part):
    breaks = []

    for i in range(1, len(part) - 1):
        line, next = part[:i], part[i:]

        #print line, next

        # http://www.rusyaz.ru/pr/opp.html
        # § 117. При переносе слов нельзя ни оставлять в конце строки, ни переносить на другую сторону часть слова,
        # не составляющую слога; например, нельзя переносить просмо-тр, ст-рах.
        if not SYLLABLE.match(line) or not SYLLABLE.match(next):
            #print 117
            continue

        # § 118. Нельзя отделять согласную от следующей за ней гласной.
        if line[-1].lower() in CONSONANTS and next[0].lower() in VOWELS:
            #print 118
            continue

        # § 119.
        # 1. Нельзя отрывать буквы ъ и ь от предшествующей согласной.
        if next[0].lower() in [u'ъ', u'ь']:
            #print 119.1
            continue

        # § 119. 2. Нельзя отрывать букву й от предшествующей гласной.
        if next[0].lower() == u'й':
            #print 119.2
            continue

        # 3. Нельзя оставлять в конце строки или переносить на другую строку одну букву.
        if len(line) < 2 or len(next) < 2:
            #print 119.3
            continue

        # TODO: 4. При переносе слов с приставками нельзя разбивать односложную приставку, если за приставкой идёт согласный.

        # TODO: 5. При переносе слов с приставками нельзя оставлять в конце строки при приставке начальную часть корня, не составляющую слога.

        # TODO: 6. При переносе сложных слов нельзя оставлять в конце строки начальную часть второй основы, если эта часть не составляет слога.

        # TODO: 7. Нельзя оставлять в конце строки или переносить в начало следующей две одинаковые согласные, стоящие между гласными.

        # TODO: 8. Нельзя разбивать переносом односложную часть сложносокращённого слова.

        # TODO §§ 120, 121, 122, 123, 124

        breaks.append(i)

    if not breaks:
        return part

    chunks = []

    prev_break = 0

    for b in breaks:
        chunks.append(part[prev_break:b])

        prev_break = b

    chunks.append(part[breaks[-1]:])

    return "<wbr />".join(chunks)


def hyphenize(s):
    words = s.split()

    return " ".join("-".join(map(_hyphenize, word.split('-'))) for word in words)
