# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from lib.utils import comb_list
from www.templatetags.block_found_routes import segment_company
from staticpages.templatetags.static import parametric_text
from itertools import cycle

from xgettext.i18n import gettext, xgettext
from www.utils.date import DateTimeFormatter

# Шаблоныf
from travel.rasp.morda.morda.templates.station.base import Template as Base
from travel.rasp.morda.morda.utils.locations import station_thread_url
from ..utils import mdash_wrappable
from ..timetable import TimeOnlyFormatter, TimeWithDateIfChangedFormatter


class Template(Base):
    page = 'tstation'

    def hrows(self):
        context = self.context
        station = context.station

        return [
            {
                'elem': 'hrow',
                'content': [
                    { 'elem': 'cell' },
                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'timeselector' },
                        'content': {
                            'block': 'b-timeselector',
                            'mods': { 'type': 'header' },
                            'content': [
                                {
                                    'elem': 'selector',
                                    'content': [
                                        {
                                            'block': 'b-icon'
                                        },
                                        self.timeselector(),
                                    ]
                                },
                            ]
                        }
                    },
                    not context.date and { 'elem': 'cell' } or ''
                ]
            },
            {
                'elem': 'hrow',
                'elemMods': { 'position': 'last' },
                'content': [
                    self.hrow_cell(column, name) for column, name in filter(None, [
                        ('trip', gettext('рейс')),
                        ('name', station.L_short_title_with_prefix()),
                        not context.date and ('days', gettext('дни курсирования')),
                    ])
                ]
            }
        ]

    def rows(self):

        station = self.context.station
        schedule = self.context.schedule
        mark_cycle = cycle([None, 'mark'])

        if schedule:
            time_formatter = TimeWithDateIfChangedFormatter(self) if self.context.date else TimeOnlyFormatter(self)

            json_rows = []

            for j, schedule_route in enumerate(schedule):
                loop_last = j == len(schedule) - 1
                mark_class = mark_cycle.next()

                thread_link_content =  [
                    {
                        'elem': 'text',
                        'tag': 'strong',
                        'content': schedule_route.thread.number
                    },
                    ' ',
                    mdash_wrappable(schedule_route.title)
                ]
                thread_url = station_thread_url(schedule_route.thread, schedule_route.start_date, self.context.request)

                row = {
                    'elem': 'row',
                    'mods': {
                        'mark': self.context.get('print', False) and mark_class or '',
                        'type': schedule_route.cancel and 'canceled' or '',
                        'position': loop_last and 'last',
                    },
                    'content': [
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'trip' },
                            'content': [
                                {
                                    'elem': 'tripname',
                                    'content': [
                                        self.context.get('print', False) and [
                                            schedule_route.thread.number, ' ', mdash_wrappable(schedule_route.thread.title_short)
                                        ],
                                        ' ',
                                        (
                                            {
                                                'block': 'b-link',
                                                'url': thread_url,
                                                'mods': {},
                                                'content': thread_link_content,
                                            }
                                            if thread_url else
                                            thread_link_content
                                        ),
                                    ]
                                },
                                {
                                    'elem': 'description',
                                    'content': comb_list(', ', [
                                        gettext('теплоход'),
                                        segment_company(schedule_route),
                                    ])
                                },
                            ]
                        },
                        {
                            'elem': 'cell',
                            'elemMods': {'type': self.context.event},
                            'content': {
                                'elem': 'time',
                                'content': time_formatter(schedule_route.event_dt)
                            }
                        },
                        not self.context.date and {
                            'elem': 'cell',
                            'elemMods': {'type': 'days'},
                            'content': self.days_text(schedule_route),
                        } or '',
                    ]
                }
                json_rows.append(row)

            return json_rows
        else:
            if self.context.date:
                content = xgettext('Нет информации о теплоходах, отправляющихся <date format="%d %B"/>. '
                                   'Попробуйте посмотреть <b-link>расписание на все дни</b-link>.',
                                   date=DateTimeFormatter(self.context.date).L,
                                   b_link=lambda content: {
                                       'block': 'b-link',
                                       'url': self.station_url(span='schedule'),
                                       'content': content
                                   }
                )
            else:
                content = ''

            return [
                {
                    'elem': 'row',
                    'elemMods': { 'type': 'no-bottom' },
                    'content': [
                        {
                            'elem': 'cell',
                            'attrs': { 'colspan': '2' if self.context.date else '3' },
                            'content': [
                                '<!-- noindex -->',
                                '<br/>',
                                {
                                    'block': 'b-static-text',
                                    'mix': [{ 'block': 'b-notice' }],
                                    'content': content
                                },
                                '<br/>',
                                '<!-- /noindex -->',
                            ]
                        }
                    ]
                }
            ]

    def b_timetable(self):
        return {
            'block': 'b-timetable',
            'mods': { 'preset': 'station' },
            'js': {
                'timecolumns': [self.context.event],
                'mode': not self.context.date and 'schedule' or ''
            },
            'content': self.hrows() + self.rows()
        }

    def content(self):
        station = self.context.station

        return [
            {
                'block': 'l-page',
                'mods': { 'layout': '72-20', 'row': 'multiple' },
                'content': [
                    self.content_first_row(),
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'gap'
                            },
                            {
                                'elem': 'left',
                                'content': [
                                    {
                                        'block': 'b-tablo-triggers',
                                        'content': [
                                            self.b_datelinks(),
                                            self.b_triggers(),
                                        ]
                                    },
                                    {
                                        'block': 'b-layout-table',
                                        'mods': { 'layout': 'tsearch' },
                                        'content': [
                                            {
                                                'elem': 'row',
                                                'content': [
                                                    {
                                                        'elem': 'cell',
                                                        'elemMods': { 'type': 'tabs' },
                                                        'content': {
                                                            'block': 'b-timetable-trigger',
                                                            'content': [
                                                                self.e_event_tab('departure', gettext('Отправление'), self.context.event),
                                                                self.e_event_tab('arrival', gettext('Прибытие'), self.context.event),
                                                            ]
                                                        }
                                                    },
                                                ]
                                            }
                                        ]
                                    },
                                    self.b_timetable(),
                                    {
                                        'block': 'b-description-text',
                                        'content': [
                                            {
                                                'elem': 'item',
                                                'content': parametric_text('sea_schedule_disclaimer', station_title=station.L_popular_title, year=self.context.request.now.year)
                                            }
                                        ]
                                    },
                                    {
                                        'elem': 'item',
                                        'cls': 'i-media-print',
                                        'content': self.b_link_place_on_my_site()
                                    },
                                    '<img src="//clck.yandex.ru/click/dtype=stred/pid=168/cid=72126/*http://yandex.ru" alt="" />'
                                ]
                            },
                            {
                                'elem': 'gap-right'
                            },
                            {
                                'elem': 'right',
                                'content': self.right_content(),
                            },
                            {
                                'elem': 'gap'
                            }
                        ]
                    }
                ]
            }
        ]
