# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.bemhtml import wrap
from common.utils.weather import weather_data
from common.xgettext.i18n import gettext


def station_info(request, station):
    weather = station and wrap(weather_data(request, station))

    if weather:
        image = weather.get('image-v3')

        if not image or (image == 'None'):
            image = ''

        return {
            'block': 'b-city-short-info',
            'content': [
                station.settlement and {
                    'elem': 'city',
                    'content': station.settlement.L_title()
                } or '',
                station.country and {
                    'elem': 'country',
                    'content': station.country.L_title()
                } or '',
                {
                    'elem': 'links',
                    'content': [
                        weather.url and {
                            'block': 'b-link',
                            'url': weather.url,
                            'content': gettext(u'погода')
                        },
                        image and {
                            'block': 'b-icon',
                            'mods': { 'type': 'weather' },
                            'url': '//yandex.st/weather/i/icons/22x22/%s.png' % image,
                            'alt': weather.weather_type,
                            'attrs': { 'alt': gettext('Облачно') }
                        } or '&nbsp',
                        ' %s &#0176;C' % weather.temperature
                    ]
                }
            ]
        }

