# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.bemhtml import punctuate_content
from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xgettext
from travel.rasp.morda.morda.templates.base import Base


class Template(Base):
    page = 'precise'

    def content(self):

        russia_checkbox_attrs = {'id': 'filter_country_yes', 'name': 'current', 'value': 'yes'}
        other_checkbox_attrs = {'id': 'filter_other_yes', 'name': 'other', 'value': 'yes'}

        if getattr(self.context.station_form, 'cleaned_data', None):
            if self.context.station_form.cleaned_data['current']:
                russia_checkbox_attrs['checked'] = 'checked'

            if self.context.station_form.cleaned_data['other']:
                other_checkbox_attrs['checked'] = 'checked'

        return [{
            'block': 'l-page',
            'mods': { 'layout': '72-20' },
            'content': [
                { 'elem': 'gap' },
                {
                    'elem': 'left',
                    'content': [
                        {
                            'block': 'b-page-title',
                            'content':{
                                'elem': 'title',
                                'content': self.get_title()
                            }
                        },
                        {
                            'block': 'l-precise',
                            'content': self.precise_content()
                        }
                    ]
                },
                {'elem': 'gap-right'},
                {
                    'elem': 'right',
                    'content': [
                        {
                            'block': 'b-filter-title',
                            'content': gettext('Поиск станции по запросу')
                        },
                        {
                            'block': 'b-filter',
                            'js': True,
                            'content':{
                                'elem': 'form',
                                'tag': 'form',
                                'attrs': {'action': '?'},
                                'content': {

                                    'elem': 'content',
                                    'content': [
                                        {
                                            'block': 'b-menu-vert-mod',
                                            'mods': {'preset': 'filter'},
                                            'js': True,
                                            'content':[
                                                {
                                                    'elem': 'item',
                                                    'content': {
                                                        'elem': 'trigger',
                                                        'mods': {'state': 'opened'},
                                                        'content': [
                                                            {
                                                                'block': 'b-icon',
                                                                'mix': [{'block': 'b-menu-vert-mod', 'elem': 'trigger-icon'}],
                                                                'alt': '+'
                                                            },
                                                            {
                                                                'block': 'b-link',
                                                                'mods': {'pseudo': 'yes', 'theme': 'black'},
                                                                'content': gettext('Название станции')
                                                            },
                                                        ]
                                                    },
                                                    'item-content': {
                                                        'elem': 'item-content',
                                                        'mods': {'visibility': 'visible'},
                                                        'content': {
                                                            'block': 'b-menu-vert-mod',
                                                            'mods': {'type': 'submenu'},
                                                            'content': [
                                                                {
                                                                    'elem': 'item',
                                                                    'content': {
                                                                        'block': 'b-form-input',
                                                                        'js': {
                                                                            'dataprovider': { 'url': self.all_suggest_url() },
                                                                            'key-name': 'cityFromId',
                                                                            'debounceDelay': 100,
                                                                        },
                                                                        'mods': {
                                                                            'theme': 'grey',
                                                                            'size': 'm',
                                                                            'has-clear': 'yes',
                                                                            'is-bem': 'yes',
                                                                            'pick': 'yes',
                                                                            'autocomplete': 'yes',
                                                                            'autocomp-right': 'yes',
                                                                        },
                                                                        'content': [
                                                                            {
                                                                                'elem': 'input',
                                                                                'attrs': {
                                                                                    'id': 'station_cityFrom',
                                                                                    'name': 'cityFrom',
                                                                                    'value': self.context.city_from,
                                                                                }
                                                                            }
                                                                        ]
                                                                    }
                                                                },
                                                            ]
                                                        }
                                                    }
                                                },
                                                {
                                                    'elem': 'item',
                                                    'content': {
                                                        'elem': 'trigger',
                                                        'mods': {'state': 'opened'},
                                                        'content': [
                                                            {
                                                                'block': 'b-icon',
                                                                'mix': [{'block': 'b-menu-vert-mod', 'elem': 'trigger-icon'}],
                                                                'alt': '+'
                                                            },
                                                            {
                                                                'block': 'b-link',
                                                                'mods': {'pseudo': 'yes', 'theme': 'black'},
                                                                'content': gettext('Где искать')
                                                            }
                                                        ]
                                                    },
                                                    'item-content': {
                                                        'elem': 'item-content',
                                                        'mods': {'visibility': 'visible'},
                                                        'content': {
                                                            'block': 'b-menu-vert-mod',
                                                            'mods': {'type': 'submenu'},
                                                            'content':[
                                                                {
                                                                    'elem': 'item',
                                                                    'content': {
                                                                        'block': 'b-form-checkbox',
                                                                        'mods': {'theme': 'grey-m', 'size': 'm'},
                                                                        'checkboxAttrs': russia_checkbox_attrs,
                                                                        'content': { 'elem': 'label', 'content': self.context.current_country_name }
                                                                    }
                                                                },
                                                                {
                                                                    'elem': 'item',
                                                                    'content': {
                                                                        'block': 'b-form-checkbox',
                                                                        'mods': {'theme': 'grey-m', 'size': 'm'},
                                                                        'checkboxAttrs': other_checkbox_attrs,
                                                                        'content': { 'elem': 'label', 'content': gettext('за рубежом') }
                                                                    }
                                                                }
                                                            ]
                                                        }
                                                    }
                                                },
                                            ]
                                        },
                                        {
                                            'elem': 'show',
                                            'content': {
                                                'block': 'b-form-button',
                                                'mods': {'size': 'm', 'theme': 'grey-m'},
                                                'type': 'submit',
                                                'content': gettext('Показать'),
                                                'attrs': {
                                                    'onmousedown': self.metrika_reach_goal("dedicated_station_search_button_click")
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        },
                        self.teaser('ahtung'),
                    ]
                },
                {'elem': 'gap'}
            ]
        }]

    def get_title(self):
        if not self.context.variants:
            title = gettext('Ничего не найдено')
        else:
            title = gettext('Найденные варианты:')

        return title

    def precise_item(self, point):
        if getattr(point, 'has_omonims', None):
            place = '(%s)' % point.L_full_geography(show_district=True)

        else:
            if getattr(point, 'settlement', None):
                place = '(%s)' % point.settlement.L_title_with_prefix()

            elif getattr(point, 'region', None):
                place = '(%s)' % point.region.L_title()

            elif not point.disputed_territory:
                place = '(%s)' % point.country.L_title()

        return {
            'elem': 'item',
            'content': [
                {
                    'elem': 'station',
                    'content': { 'block': 'b-link', 'url': point.url, 'content': point.L_title_with_prefix() }
                },
                '&#0160;',
                {
                    'elem': 'place',
                    'content': place
                }
            ]
        }

    def precise_content(self):
        if not self.context.variants:
            if self.context.station_form.data.get('cityFrom', None):
                if self.context.error:
                    title = self.context.error
                else:
                    title = gettext('К сожалению, запрошенная вами станция не найдена.')
            else:
                title = gettext('Введите название станции или города.')

            return [{
                'elem': 'column',
                'content': [
                    {
                        'block': 'b-precise-title',
                        'content': title
                    }
                ]
            }]


        res = []
        if self.context.variants:
            for header, group in self.context.variants:
                r = {
                    'elem': 'column',
                    'content': [
                        {
                            'block': 'b-precise-title',
                            'content': header,
                        },
                        {
                            'block': 'b-precise-list',
                            'content': [self.precise_item(point) for point in group]
                        }
                    ]
                }
                res.append(r)

        return res


class CountryTemplate(Template):
    def get_title(self):
        return ''

    def airports_links(self, airports):
        links = [
            [
                punctuate_content(
                    [
                        airport.station_type.L_prefix(),
                        {
                            'block': 'b-link',
                            'url': composeurl('station', args=[airport.id]),
                            'content': airport.L_title()
                        },
                    ],
                    '&nbsp'
                )
            ] for airport in airports
        ]
        return punctuate_content(links)

    def precise_item(self, variant):
        settlement, stations = variant

        city_title = xgettext('г. <city-title/>', city_title=settlement.L_title)

        if len(stations) == 1:
            content = [
                {
                    'block': 'b-link',
                    'url': composeurl('station', args=[stations[0].id]),
                    'content': city_title
                }
            ]
        else:
            content = [
                {
                    'block': 'b-link',
                    'url': composeurl('city', args=[settlement.id]),
                    'content': city_title
                },
                ' ('
            ] + self.airports_links(stations) + [')']

        return {
            'elem': 'item',
            'cls': 'b-precise-list__station',
            'content': content
        }

    def precise_content(self):
        return [{
            'elem': 'column',
            'content': [
                {
                    'block': 'b-precise-title',
                    'content': self.context.precise_title
                },
                {
                    'block': 'b-precise-list',
                    'content': [self.precise_item(variant) for variant in self.context.airports]
                }
            ]
        }]
