# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from travel.rasp.morda.morda.templates.thread.trip import Template as Base
from travel.rasp.morda.morda.templates.utils import wrap_with_link


class Template(Base):

    def b_timetable_head(self):
        return self.b_timetable_short_head()

    def b_timetable_first_column(self, st):
        thread = self.context.thread
        station_url = st.station.show_link and self.station_url(st.id)

        return {
            'elem': 'cell',
            'elemMods': {'type': 'trip'},
            'content': [

                self.start_finish_markers(st),

                {
                    'elem': 'city',
                    'elemMods': { 'type': st.is_technical_stop and 'tech' or None },
                    'content': [
                        wrap_with_link(st.station.L_title(), url=station_url),
                        st.station.settlement and thread.route and thread.route.supplier and thread.route.supplier.code == 'mta' and [
                            ' ',
                            {
                                'elem': 'gray',
                                'tag': 'span',
                                'content': ['(', st.station.settlement.L_title(), ')']
                            }
                        ],
                        st.is_technical_stop and '*' or '',
                        ]
                }

            ]
        }

    def b_timetable_row(self, st, loop, *args):
        thread = self.context.thread

        return {
            'elem': 'row',
            'elemMods': self.b_timetable_row_elemMods(st, loop),
            'content': [
                self.b_timetable_first_column(st),
                {
                    'elem': 'cell',
                    'elemMods': {'type': 'departure'},
                    'content': {
                        'block': 'b-interval-time',
                        'content': '' if not loop.first else [
                            {
                                'elem': 'row',
                                'content': [
                                    { 'elem': 'day', 'content': self.context.calendar.template },
                                    {
                                        'elem': 'times',
                                        'content': [
                                            {
                                                'elem': 'time',
                                                'tag': 'span',
                                                'content': [
                                                    thread.begin_time.strftime('%H:%M'),
                                                    '...',
                                                    thread.end_time.strftime('%H:%M')
                                                ]
                                            },
                                            thread.density and [
                                                ', ',
                                                {
                                                    'elem': 'desc',
                                                    'tag': 'span',
                                                    'content': thread.density
                                                }
                                            ],
                                            {
                                                'elem': 'comment',
                                                'content': thread.comment
                                            }
                                        ]
                                    }
                                ]
                            },
                        ]
                    }
                },
                self.b_timetable_row_pathtime_column(st),
            ]
        }
