# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import date, datetime

from common.utils.date import astimezone, FuzzyDateTime, uni_strftime
from common.utils.locations import composeurl, set_lang_param
from common.xgettext.i18n import gettext
from common.utils import request_helper


def headnonzerononfail(*funcs):
    for func in funcs:
        try:
            rv = func()

            if rv:
                return rv

        except Exception:
            pass


def segment_company(segment):
    company = getattr(segment, 'company', None)

    if company and not company.hidden:
        title = company.L_short_title() or company.L_title()

        if title:
            if not company.strange:
                return {
                    'block': 'b-link',
                    'url': composeurl('info_object', args=['company', company.id]),
                    'content': title,
                }

            return title


def segment_strong_number(segment, number=None):
    t_type = getattr(segment, 't_type', None)

    number = number or getattr(segment, 'number', None)

    if t_type and t_type.code in ['train', 'plane']:
        return number and "<strong>%s</strong>" % number

    if not getattr(segment, 'show_number', True):
        return None

    return getattr(segment, 'number', None)


def search_url(city_from, city_to, when=None, method='search', **extra):
    params = {
        'fromName': city_from.L_title(),
        'fromId': city_from.point_key,
        'toName': city_to.L_title(),
        'toId': city_to.point_key,
        }

    # TODO: сделать функцию, которая формирует строку для поля даты
    if isinstance(when, date) or isinstance(when, datetime):
        params['when'] = uni_strftime('%d %B', when)
    elif when is None:
        params['when'] = gettext('на все дни')
    else:
        params['when'] = when

    params.update(extra)

    # Убираем None
    params = dict((k, v) for k, v in params.items() if v is not None)

    return composeurl(method, params=params)


def json_dt_struct(dt, tz_cities, col=None):
    shifts = {}

    local_dt = dt.replace(tzinfo=None)

    for city in tz_cities:
        delta = astimezone(dt, city).replace(tzinfo=None) - local_dt
        shifts[city.id] = delta.seconds / 60 + delta.days * 24 * 60

    data = {
        'local': dt.strftime("%B %d, %Y %H:%M:%S"),
        'shifts': shifts
    }

    if col:
        data['col'] = col

    if isinstance(dt, FuzzyDateTime):
        data['fuzzy'] = True

    return data


def bus_route_showed_strong_number(scheduleroute):
    number = scheduleroute.displayed_number
    return number and '<strong>%s</strong>' % number or ''


def wrap_with_link(content, url, mods=None):
    if mods is None:
        mods = dict()

    return url and {
        'block': 'b-link',
        'url': url,
        'mods': mods,
        'content': content,
        } or content


def buy_link(request, params):
    return "//{clck_host}/redir/dtype=stred/pid=168/cid=70831/*//{host}/buy/?{params}".format(
        clck_host=request.clck_host,
        host=request_helper.get_host(request),
        params=set_lang_param(params)
    )
