# -*- coding: utf-8 -*-

from __future__ import absolute_import

from common.models.transport import TransportType
from common.utils.locations import composeurl
from common.utils.avia import get_avia_thread_url


def search_url(city_from, city_to, search_type=None, next=False, **extra):
    params = get_from_to_params(city_from, city_to)

    params.update(extra)

    if next:
        view = 'search_next'
    else:
        view = 'search'

    args = [search_type] if search_type else []

    return composeurl(view, args=args, params=params)


def suburban_search_url(city_from, city_to, next=False, **extra):
    params = get_from_to_params(city_from, city_to)

    params.update(extra)

    if next:
        view = 'search_next'
    else:
        view = 'search'

    return composeurl(view, args=['suburban'], params=params)


def get_from_to_params(city_from, city_to):
    if isinstance(city_from, tuple):
        title_from, key_from = city_from
    else:
        title_from, key_from = city_from.L_title(), city_from.point_key

    if isinstance(city_to, tuple):
        title_to, key_to = city_to
    else:
        title_to, key_to = city_to.L_title(), city_to.point_key

    return {
        'fromName': title_from,
        'fromId': key_from,
        'toName': title_to,
        'toId': key_to,
    }


def aeroexpress_search_url(airport, reverse=False):
    if not airport.t_type.code == 'plane':
        return None

    if not airport.has_aeroexpress:
        return None

    if not airport.settlement:
        return None

    if reverse:
        point_from = airport
        point_to = airport.settlement
    else:
        point_from = airport.settlement
        point_to = airport

    return suburban_search_url(point_from, point_to, aeroex='y')


def tablo_link(z_tablo, request):
    if not z_tablo.thread:
        return None
    return station_thread_url(z_tablo.thread, z_tablo.start_date, request)


def station_thread_url(thread, departure, request):
    if thread.t_type_id == TransportType.PLANE_ID:
        return get_avia_thread_url(thread, request.tld, departure,
                                   utm_medium='station_landing', utm_campaign='flight_link')
    params = {}
    if departure and not request.yandex_bot:
        params['departure'] = departure
    return composeurl('thread', args=[thread.uid], params=params)
