# -*- coding: utf-8 -*-

from __future__ import absolute_import

from django.conf import settings

from geosearch.views.point import NoPointsError
from geosearch.views.pointlist import PointList

from suggests.suggests.api import find_suggests
from suggests.suggests.search import get_points_from_suggests


def suggest_points(query, t_type_code, client_city):
    suggests = find_suggests(
        query, t_type_code, client_city,
        limit=settings.SUGGEST_POINTS_LIMIT
    ).suggests

    if not suggests:
        raise NoPointsError(query)

    points = PointList(None, get_points_from_suggests(suggests), term=query)

    points.allow_reduce = False
    points.dont_rearrange = True

    return points
