# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import timedelta, date

from django.http import Http404
from django.shortcuts import get_object_or_404

from common.models.geo import Settlement
from common.utils.date import human_date_without_year

from travel.rasp.morda.morda.forms import SearchForm
from travel.rasp.morda.morda.views.city import city as city_view


ACTIVE_TAB_VARIANTS = ['bus', 'plane', 'train', 'suburban', 'all']
AUTOFOCUS_VARIANTS = ['toName', 'fromName', 'when']


def prefill(request):
    context = dict()

    city = get_city_or_404(request.GET.get('city_id', ''))

    active_tab = request.GET.get('active_tab', 'all')

    if active_tab in ACTIVE_TAB_VARIANTS:
        context['search_type'] = active_tab

    autofocus = request.GET.get('autofocus')

    if autofocus in AUTOFOCUS_VARIANTS:
        context['autofocus_field'] = autofocus

    to_city = get_city_or_none(request.GET.get('to_city_id', ''))
    from_city = get_city_or_none(request.GET.get('from_city_id', ''))

    when_str = request.GET.get('when', '')

    if when_str == 'tomorrow':
        # TODO: Возможно нужно вычислять дату исходя из времени в city_ или from_city
        when = request.now.date() + timedelta(1)

    else:
        when = parse_date(when_str)

    context['search_form'] = SearchForm(request=request, initial={
        'fromName': from_city and from_city.L_title() or '',
        'toName': to_city and to_city.L_title() or '',
        'when': when and human_date_without_year(when) or '',
    })

    return city_view(request, code=str(city.pk), extra_context=context)


def get_city_or_404(city_id):
    if city_id.isdigit():
        return get_object_or_404(Settlement.hidden_manager, pk=city_id)

    raise Http404()


def get_city_or_none(city_id):
    try:
        return get_city_or_404(city_id)

    except Http404:
        return None


def parse_date(date_str):
    try:
        return date(*map(int, date_str.split('-')))

    except (TypeError, ValueError, AttributeError):
        return None


