# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.http import Http404, HttpResponseRedirect

from common.models.geo import Settlement
from common.utils.locations import composeurl, langify


def promo(request, code):
    """
    https://jira.yandex-team.ru/browse/RASP-15655
    Получает geo-id города и редиректит на обычную страницу /city с кодом из базы расписаний
    """

    if code.isdigit():
        try:
            city = Settlement.hidden_manager.get(_geo_id=code)

        except Settlement.DoesNotExist:
            return HttpResponseRedirect(langify('/'))

        params = {
            'active_tab': 'bus',
            'autofocus': 'toName',
            'when': 'tomorrow',
            'from_city_id': city.pk,
            'city_id': city.pk,
        }

        return HttpResponseRedirect(composeurl('city_prefill', params=params))

    else:
        raise Http404


def from_promo(request, code):
    """
    Обработка переходов с промо
    code - код промо, с которого перешли на Яндекс.Расписания
    Остальную информацию получаем из get-параметров
    """

    if code == 'ufs-2014-08':
        return ufs_2014_08(request)

    raise Http404()


def ufs_2014_08(request):
    city = request.client_city

    params = {
        'active_tab': 'train',
        'autofocus': 'fromName',
        'when': 'tomorrow',
        'city_id': city.pk,
    }

    return HttpResponseRedirect(composeurl('city_prefill', params=params))
