# -*- coding: utf-8 -*-

from travel.rasp.morda.morda.templates.maps.air import Template as AirTemplate
from travel.rasp.morda.morda.templates.maps.compact.air import Template as CompactAirTemplate
from travel.rasp.morda.morda.templates.maps.trains import Template as TrainsTemplate
from travel.rasp.morda.morda.templates.maps.compact.trains import Template as CompactTrainsTemplate
from travel.rasp.morda.morda.templates.maps.buses import Template as BusesTemplate
from django.http import Http404


TEMPLATES_MAPPING = {
    'maps_air': AirTemplate,
    'maps_compact_air': CompactAirTemplate,
    'maps_trains': TrainsTemplate,
    'maps_compact_trains': CompactTrainsTemplate,
    'maps_buses': BusesTemplate,
}


def get_default_map_params(national_version):
    if national_version == 'tr':
        return {
            'center': [35.14, 39.02],
            'span': [22.15, 8.57],
            'zoom': 6,
        }

    if national_version == 'ua':
        return {
            'center': [31.179499, 48.424826],
            'span': [21.269531, 9.055288],
            'zoom': 6,
        }

    return {
        'center': [37.64, 55.76],
        'span': [44.30, 12.42],
        'zoom': 5,
    }


def map(request, template_name):
    context = {
        'map': get_default_map_params(request.NATIONAL_VERSION)
    }

    template_class = TEMPLATES_MAPPING.get(template_name)

    if not template_class:
        raise Http404

    return template_class.render(request, context)

