# -*- coding: utf-8 -*-

import time

from django.db import connection

from travel.rasp.morda.morda.models.mapping import DefaultSuggest


class Suggests(object):
    timeout = 600

    def __init__(self, sql, default_suggest=None):
        self._sql = sql
        self._last_retrieved = 0
        self._default_suggest = default_suggest

    def variants_iter(self, query, limit=10):
        self._retrieve_suggests()

        return self._suggest_iter(self._variants, query, limit)

    def _retrieve_suggests(self):
        current = time.time()

        if current - self._last_retrieved < self.timeout:
            return

        cursor = connection.cursor()
        cursor.execute(self._sql)

        self._variants = [r[0] for r in cursor.fetchall() if r[0]]

        self._last_retrieved = current

    def _suggest_iter(self, variants, query, limit):
        count = 0
        present = set()

        if query:
            for suggest in variants:
                if count > limit:
                    break

                if suggest in present:
                    continue

                if suggest.lower().startswith(query):
                    yield suggest

                    present.add(suggest)
                    count += 1

        if not count:
            found = False

            if self._default_suggest:
                for suggest in DefaultSuggest.get_suggests(self._default_suggest):
                    found = True

                    yield suggest

            if not found:
                for suggest in variants:
                    if suggest in present:
                        continue

                    yield suggest

                    present.add(suggest)
                    count += 1

                    if count > limit:
                        break


def variants_to_response(variants):
    l = list(variants)
    return [None, l, None]
