# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import timedelta
from functools import wraps

from common.models.transport import TransportType
from geosearch.views.pointtopoint import iter_extended_points
from route_search.shortcuts import search_routes, find_next


def extend_search(func):
    @wraps(func)
    def decorated(context, t_type_code, point_from, point_to, *args, **kwargs):
        extended_points = None
        segments, service_types = func(context, t_type_code, point_from, point_to, *args, **kwargs)

        if not segments:
            # Обобщение до городов
            for extended_point_from, extended_point_to in iter_extended_points(point_from, point_to, (t_type_code == 'suburban')):
                segments, service_types = func(context, t_type_code, extended_point_from, extended_point_to, *args, **kwargs)

                if segments:
                    context.update({
                        'extended': True,
                        'request_from': point_from,
                        'request_to': point_to,
                        'from': extended_point_from,
                        'to': extended_point_to,
                    })

                extended_points = extended_point_from, extended_point_to

        return segments, service_types, extended_points

    return decorated


# Данные из контекста использовать нежелательно, так как это приводит к неочевидным
# зависимостям

@extend_search
def search(context, t_type_code, point_from, point_to, when, prev_date=None, include_interval=True, add_z_tablos=False):
    segments, context['days'], service_types = search_routes(
        point_from,
        point_to,
        departure_date=when,
        transport_types=t_type_code and [TransportType.objects.get(code=t_type_code)],
        check_date=prev_date,
        include_interval=include_interval,
        add_z_tablos=add_z_tablos
    )

    context['any_routes'] = bool(service_types)

    if when:
        context['days'] = {
            'earlier': {'date': when - timedelta(1), 'count': None},
            'later': {'date': when + timedelta(1), 'count': None},
        }

    return segments, service_types


@extend_search
def search_next(context, t_type_code, point_from, point_to, now):
    segments = list(find_next(
        point_from,
        point_to,
        now,
        t_type_code and TransportType.objects.get(code=t_type_code),
    ))

    return segments, set(s.t_type.code for s in segments)
