# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import timedelta

from django.conf import settings

from common.models.geo import Settlement, Station
from travel.rasp.morda.morda.templates.search import NoRoutesHints
from travel.rasp.morda.morda.views.search.teasers import teaser_data


def has_city_incomplete_schedules(settlement):
    return settlement.station_set.filter(incomplete_bus_schedule=True, hidden=False).count()


def no_routes(request, when, context, search_type):
    days = context.get('days', {})

    if 'later' in days:
        context['later_or_earlier'] = days['later']['date']
    elif 'earlier' in days:
        context['later_or_earlier'] = days['earlier']['date']
    elif when:
        context['earliest'] = when - timedelta(days=settings.SEARCH_EARLIER)
        context['latest'] = when + timedelta(days=settings.SEARCH_LATER)

    # RASP-10644 Показывать тизеры при отсутствии рейсов в выдаче
    context.update(teaser_data(request, [], context['from'], context['to'], search_type))

    context['date'] = when
    if isinstance(context['from'], Settlement):
        context['incomplete_schedule'] = has_city_incomplete_schedules(context['from'])
        context['from_is_station'] = False
    elif isinstance(context['from'], Station):
        context['incomplete_schedule'] = context['from'].incomplete_bus_schedule
        context['from_is_station'] = True
    else:
        context['from_is_station'] = False

    return NoRoutesHints.render(request, context)
